/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.impl;

import io.camunda.zeebe.stream.api.StreamClock;
import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.time.Instant;
import java.time.InstantSource;
import java.util.Objects;

public final class ControllableStreamClockImpl
implements StreamClock.ControllableStreamClock {
    private final InstantSource source;
    private volatile StreamClock.ControllableStreamClock.Modification modification;

    public ControllableStreamClockImpl(InstantSource source) {
        this.source = Objects.requireNonNull(source);
        this.reset();
    }

    @Override
    public void applyModification(StreamClock.ControllableStreamClock.Modification modification) {
        this.modification = modification;
    }

    @Override
    public StreamClock.ControllableStreamClock.Modification currentModification() {
        return this.modification;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Instant instant() {
        Instant instant;
        StreamClock.ControllableStreamClock.Modification modification = this.modification;
        Objects.requireNonNull(modification);
        StreamClock.ControllableStreamClock.Modification modification2 = modification;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StreamClock.ControllableStreamClock.Modification.None.class, StreamClock.ControllableStreamClock.Modification.Offset.class, StreamClock.ControllableStreamClock.Modification.Pin.class}, (Object)modification2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                StreamClock.ControllableStreamClock.Modification.None none = (StreamClock.ControllableStreamClock.Modification.None)modification2;
                instant = this.source.instant();
                return instant;
            }
            case 1: {
                StreamClock.ControllableStreamClock.Modification.Offset offset = (StreamClock.ControllableStreamClock.Modification.Offset)modification2;
                try {
                    Duration duration;
                    Duration offset2 = duration = offset.by();
                    instant = this.source.instant().plus(offset2);
                    return instant;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 2: 
        }
        StreamClock.ControllableStreamClock.Modification.Pin pin = (StreamClock.ControllableStreamClock.Modification.Pin)modification2;
        {
            Instant instant2;
            Instant pinnedAt;
            instant = pinnedAt = (instant2 = pin.at());
        }
        return instant;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long millis() {
        long l;
        StreamClock.ControllableStreamClock.Modification modification = this.modification;
        Objects.requireNonNull(modification);
        StreamClock.ControllableStreamClock.Modification modification2 = modification;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StreamClock.ControllableStreamClock.Modification.None.class, StreamClock.ControllableStreamClock.Modification.Pin.class, StreamClock.ControllableStreamClock.Modification.Offset.class}, (Object)modification2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                StreamClock.ControllableStreamClock.Modification.None none = (StreamClock.ControllableStreamClock.Modification.None)modification2;
                l = this.source.millis();
                return l;
            }
            case 1: {
                StreamClock.ControllableStreamClock.Modification.Pin pin = (StreamClock.ControllableStreamClock.Modification.Pin)modification2;
                try {
                    Instant instant;
                    Instant at = instant = pin.at();
                    l = at.toEpochMilli();
                    return l;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 2: 
        }
        StreamClock.ControllableStreamClock.Modification.Offset offset = (StreamClock.ControllableStreamClock.Modification.Offset)modification2;
        {
            Duration duration;
            Duration offset2 = duration = offset.by();
            l = this.source.millis() + offset2.toMillis();
        }
        return l;
    }

    public int hashCode() {
        return Objects.hash(this.source, this.modification);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ControllableStreamClockImpl)) {
            return false;
        }
        ControllableStreamClockImpl that = (ControllableStreamClockImpl)o;
        return Objects.equals(this.source, that.source) && Objects.equals(this.modification, that.modification);
    }

    public String toString() {
        return "ControllableStreamClock{source=" + String.valueOf(this.source) + ", modification=" + String.valueOf(this.modification) + "}";
    }
}

