/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;

public final class AtomicUtil {
    private AtomicUtil() {
    }

    public static <T> T replace(AtomicReference<T> ref, Function<T, Optional<T>> replacer, Consumer<T> rollback) {
        Optional<Object> result;
        T currentVal = null;
        Object newVal = null;
        do {
            if (newVal == null || newVal == currentVal) continue;
            rollback.accept(newVal);
        } while (!ref.compareAndSet(currentVal = (T)ref.get(), newVal = (result = replacer.apply(currentVal)).orElse(currentVal)));
        return currentVal == newVal ? null : currentVal;
    }
}

