/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing;

import io.camunda.zeebe.engine.metrics.ProcessEngineMetrics;
import io.camunda.zeebe.engine.processing.bpmn.BpmnStreamProcessor;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.message.PendingProcessMessageSubscriptionChecker;
import io.camunda.zeebe.engine.processing.message.ProcessMessageSubscriptionCorrelateProcessor;
import io.camunda.zeebe.engine.processing.message.ProcessMessageSubscriptionCreateProcessor;
import io.camunda.zeebe.engine.processing.message.ProcessMessageSubscriptionDeleteProcessor;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.processinstance.ActivateProcessInstanceBatchProcessor;
import io.camunda.zeebe.engine.processing.processinstance.CreateProcessInstanceProcessor;
import io.camunda.zeebe.engine.processing.processinstance.CreateProcessInstanceWithResultProcessor;
import io.camunda.zeebe.engine.processing.processinstance.ProcessInstanceCommandProcessor;
import io.camunda.zeebe.engine.processing.processinstance.ProcessInstanceModificationProcessor;
import io.camunda.zeebe.engine.processing.processinstance.TerminateProcessInstanceBatchProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessors;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.processing.timer.CancelTimerProcessor;
import io.camunda.zeebe.engine.processing.timer.DueDateTimerChecker;
import io.camunda.zeebe.engine.processing.timer.TriggerTimerProcessor;
import io.camunda.zeebe.engine.processing.variable.UpdateVariableDocumentProcessor;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.immutable.ScheduledTaskState;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceBatchIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceModificationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.intent.VariableDocumentIntent;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import java.util.Arrays;
import java.util.function.Supplier;

public final class ProcessEventProcessors {
    public static TypedRecordProcessor<ProcessInstanceRecord> addProcessProcessors(MutableProcessingState processingState, Supplier<ScheduledTaskState> scheduledTaskState, BpmnBehaviors bpmnBehaviors, TypedRecordProcessors typedRecordProcessors, SubscriptionCommandSender subscriptionCommandSender, DueDateTimerChecker timerChecker, Writers writers) {
        MutableProcessMessageSubscriptionState subscriptionState = processingState.getProcessMessageSubscriptionState();
        KeyGenerator keyGenerator = processingState.getKeyGenerator();
        ProcessEngineMetrics processEngineMetrics = new ProcessEngineMetrics(processingState.getPartitionId());
        ProcessEventProcessors.addProcessInstanceCommandProcessor(writers, typedRecordProcessors, processingState.getElementInstanceState());
        BpmnStreamProcessor bpmnStreamProcessor = new BpmnStreamProcessor(bpmnBehaviors, processingState, writers, processEngineMetrics);
        ProcessEventProcessors.addBpmnStepProcessor(typedRecordProcessors, bpmnStreamProcessor);
        ProcessEventProcessors.addMessageStreamProcessors(typedRecordProcessors, subscriptionState, subscriptionCommandSender, bpmnBehaviors, processingState, scheduledTaskState, writers);
        ProcessEventProcessors.addTimerStreamProcessors(typedRecordProcessors, timerChecker, processingState, bpmnBehaviors, writers);
        ProcessEventProcessors.addVariableDocumentStreamProcessors(typedRecordProcessors, bpmnBehaviors, processingState.getElementInstanceState(), keyGenerator, writers);
        ProcessEventProcessors.addProcessInstanceCreationStreamProcessors(typedRecordProcessors, processingState, writers, bpmnBehaviors, processEngineMetrics);
        ProcessEventProcessors.addProcessInstanceModificationStreamProcessors(typedRecordProcessors, processingState, writers, bpmnBehaviors);
        ProcessEventProcessors.addProcessInstanceBatchStreamProcessors(typedRecordProcessors, processingState, writers);
        return bpmnStreamProcessor;
    }

    private static void addProcessInstanceCommandProcessor(Writers writers, TypedRecordProcessors typedRecordProcessors, MutableElementInstanceState elementInstanceState) {
        ProcessInstanceCommandProcessor commandProcessor = new ProcessInstanceCommandProcessor(writers, elementInstanceState);
        Arrays.stream(ProcessInstanceIntent.values()).filter(ProcessInstanceIntent::isProcessInstanceCommand).forEach(intent -> typedRecordProcessors.onCommand(ValueType.PROCESS_INSTANCE, (Intent)intent, commandProcessor));
    }

    private static void addBpmnStepProcessor(TypedRecordProcessors typedRecordProcessors, BpmnStreamProcessor bpmnStepProcessor) {
        Arrays.stream(ProcessInstanceIntent.values()).filter(ProcessInstanceIntent::isBpmnElementCommand).forEach(intent -> typedRecordProcessors.onCommand(ValueType.PROCESS_INSTANCE, (Intent)intent, bpmnStepProcessor));
    }

    private static void addMessageStreamProcessors(TypedRecordProcessors typedRecordProcessors, MutableProcessMessageSubscriptionState subscriptionState, SubscriptionCommandSender subscriptionCommandSender, BpmnBehaviors bpmnBehaviors, MutableProcessingState processingState, Supplier<ScheduledTaskState> scheduledTaskState, Writers writers) {
        typedRecordProcessors.onCommand(ValueType.PROCESS_MESSAGE_SUBSCRIPTION, (Intent)ProcessMessageSubscriptionIntent.CREATE, new ProcessMessageSubscriptionCreateProcessor(processingState.getProcessMessageSubscriptionState(), writers)).onCommand(ValueType.PROCESS_MESSAGE_SUBSCRIPTION, (Intent)ProcessMessageSubscriptionIntent.CORRELATE, new ProcessMessageSubscriptionCorrelateProcessor(subscriptionState, subscriptionCommandSender, processingState, bpmnBehaviors, writers)).onCommand(ValueType.PROCESS_MESSAGE_SUBSCRIPTION, (Intent)ProcessMessageSubscriptionIntent.DELETE, new ProcessMessageSubscriptionDeleteProcessor(subscriptionState, writers)).withListener(new PendingProcessMessageSubscriptionChecker(subscriptionCommandSender, scheduledTaskState.get().getPendingProcessMessageSubscriptionState()));
    }

    private static void addTimerStreamProcessors(TypedRecordProcessors typedRecordProcessors, DueDateTimerChecker timerChecker, MutableProcessingState processingState, BpmnBehaviors bpmnBehaviors, Writers writers) {
        typedRecordProcessors.onCommand(ValueType.TIMER, (Intent)TimerIntent.TRIGGER, new TriggerTimerProcessor(processingState, bpmnBehaviors, writers)).onCommand(ValueType.TIMER, (Intent)TimerIntent.CANCEL, new CancelTimerProcessor(processingState.getTimerState(), writers.state(), writers.rejection())).withListener(timerChecker);
    }

    private static void addVariableDocumentStreamProcessors(TypedRecordProcessors typedRecordProcessors, BpmnBehaviors bpmnBehaviors, ElementInstanceState elementInstanceState, KeyGenerator keyGenerator, Writers writers) {
        typedRecordProcessors.onCommand(ValueType.VARIABLE_DOCUMENT, (Intent)VariableDocumentIntent.UPDATE, new UpdateVariableDocumentProcessor(elementInstanceState, keyGenerator, bpmnBehaviors.variableBehavior(), writers));
    }

    private static void addProcessInstanceCreationStreamProcessors(TypedRecordProcessors typedRecordProcessors, MutableProcessingState processingState, Writers writers, BpmnBehaviors bpmnBehaviors, ProcessEngineMetrics metrics) {
        MutableElementInstanceState elementInstanceState = processingState.getElementInstanceState();
        KeyGenerator keyGenerator = processingState.getKeyGenerator();
        CreateProcessInstanceProcessor createProcessor = new CreateProcessInstanceProcessor(processingState.getProcessState(), keyGenerator, writers, bpmnBehaviors, metrics);
        typedRecordProcessors.onCommand(ValueType.PROCESS_INSTANCE_CREATION, (Intent)ProcessInstanceCreationIntent.CREATE, createProcessor);
        typedRecordProcessors.onCommand(ValueType.PROCESS_INSTANCE_CREATION, (Intent)ProcessInstanceCreationIntent.CREATE_WITH_AWAITING_RESULT, new CreateProcessInstanceWithResultProcessor(createProcessor, elementInstanceState));
    }

    private static void addProcessInstanceModificationStreamProcessors(TypedRecordProcessors typedRecordProcessors, ProcessingState processingState, Writers writers, BpmnBehaviors bpmnBehaviors) {
        ProcessInstanceModificationProcessor modificationProcessor = new ProcessInstanceModificationProcessor(writers, processingState.getElementInstanceState(), processingState.getProcessState(), bpmnBehaviors);
        typedRecordProcessors.onCommand(ValueType.PROCESS_INSTANCE_MODIFICATION, (Intent)ProcessInstanceModificationIntent.MODIFY, modificationProcessor);
    }

    private static void addProcessInstanceBatchStreamProcessors(TypedRecordProcessors typedRecordProcessors, MutableProcessingState processingState, Writers writers) {
        typedRecordProcessors.onCommand(ValueType.PROCESS_INSTANCE_BATCH, (Intent)ProcessInstanceBatchIntent.TERMINATE, new TerminateProcessInstanceBatchProcessor(writers, processingState.getKeyGenerator(), processingState.getElementInstanceState())).onCommand(ValueType.PROCESS_INSTANCE_BATCH, (Intent)ProcessInstanceBatchIntent.ACTIVATE, new ActivateProcessInstanceBatchProcessor(writers, processingState.getKeyGenerator(), processingState.getElementInstanceState(), processingState.getProcessState()));
    }
}

