/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.task;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.camunda.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnDecisionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.bpmn.task.JobWorkerTaskProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableBusinessRuleTask;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.instance.EventTrigger;

public final class BusinessRuleTaskProcessor
implements BpmnElementProcessor<ExecutableBusinessRuleTask> {
    private final BusinessRuleTaskBehavior calledDecisionBehavior;
    private final BusinessRuleTaskBehavior jobWorkerTaskBehavior;

    public BusinessRuleTaskProcessor(BpmnBehaviors bpmnBehaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        this.calledDecisionBehavior = new CalledDecisionBehavior(bpmnBehaviors, stateTransitionBehavior);
        this.jobWorkerTaskBehavior = new JobWorkerTaskBehavior(bpmnBehaviors, stateTransitionBehavior);
    }

    @Override
    public Class<ExecutableBusinessRuleTask> getType() {
        return ExecutableBusinessRuleTask.class;
    }

    @Override
    public void onActivate(ExecutableBusinessRuleTask element, BpmnElementContext context) {
        this.eventBehaviorOf(element, context).onActivate(element, context);
    }

    @Override
    public void onComplete(ExecutableBusinessRuleTask element, BpmnElementContext context) {
        this.eventBehaviorOf(element, context).onComplete(element, context);
    }

    @Override
    public void onTerminate(ExecutableBusinessRuleTask element, BpmnElementContext context) {
        this.eventBehaviorOf(element, context).onTerminate(element, context);
    }

    private BusinessRuleTaskBehavior eventBehaviorOf(ExecutableBusinessRuleTask element, BpmnElementContext context) {
        if (element.getDecisionId() != null) {
            return this.calledDecisionBehavior;
        }
        if (element.getJobWorkerProperties() != null) {
            return this.jobWorkerTaskBehavior;
        }
        throw new BpmnProcessingException(context, "Expected to process business rule task, but could not determine processing behavior");
    }

    private static final class CalledDecisionBehavior
    implements BusinessRuleTaskBehavior {
        private final BpmnDecisionBehavior decisionBehavior;
        private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
        private final BpmnIncidentBehavior incidentBehavior;
        private final BpmnStateTransitionBehavior stateTransitionBehavior;
        private final BpmnVariableMappingBehavior variableMappingBehavior;
        private final BpmnStateBehavior stateBehavior;

        public CalledDecisionBehavior(BpmnBehaviors bpmnBehaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
            this.decisionBehavior = bpmnBehaviors.bpmnDecisionBehavior();
            this.eventSubscriptionBehavior = bpmnBehaviors.eventSubscriptionBehavior();
            this.incidentBehavior = bpmnBehaviors.incidentBehavior();
            this.stateTransitionBehavior = stateTransitionBehavior;
            this.variableMappingBehavior = bpmnBehaviors.variableMappingBehavior();
            this.stateBehavior = bpmnBehaviors.stateBehavior();
        }

        @Override
        public void onActivate(ExecutableBusinessRuleTask element, BpmnElementContext context) {
            this.variableMappingBehavior.applyInputMappings(context, element).flatMap(ok -> this.decisionBehavior.evaluateDecision(element, context)).ifRightOrLeft(ok -> {
                BpmnElementContext activated = this.stateTransitionBehavior.transitionToActivated(context);
                this.stateTransitionBehavior.completeElement(activated);
            }, failure -> this.incidentBehavior.createIncident((Failure)failure, context));
        }

        @Override
        public void onComplete(ExecutableBusinessRuleTask element, BpmnElementContext context) {
            this.variableMappingBehavior.applyOutputMappings(context, element).flatMap(ok -> this.stateTransitionBehavior.transitionToCompleted(element, context)).ifRightOrLeft(completed -> this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed), failure -> this.incidentBehavior.createIncident((Failure)failure, context));
        }

        @Override
        public void onTerminate(ExecutableBusinessRuleTask element, BpmnElementContext context) {
            ElementInstance flowScopeInstance = this.stateBehavior.getFlowScopeInstance(context);
            this.incidentBehavior.resolveIncidents(context);
            this.eventSubscriptionBehavior.findEventTrigger(context).filter(eventTrigger -> flowScopeInstance.isActive()).filter(eventTrigger -> !flowScopeInstance.isInterrupted()).ifPresentOrElse(eventTrigger -> {
                BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context);
                this.eventSubscriptionBehavior.activateTriggeredEvent(context.getElementInstanceKey(), terminated.getFlowScopeKey(), (EventTrigger)((Object)eventTrigger), terminated);
            }, () -> {
                BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context);
                this.stateTransitionBehavior.onElementTerminated(element, terminated);
            });
        }
    }

    private static interface BusinessRuleTaskBehavior {
        public void onActivate(ExecutableBusinessRuleTask var1, BpmnElementContext var2);

        public void onComplete(ExecutableBusinessRuleTask var1, BpmnElementContext var2);

        public void onTerminate(ExecutableBusinessRuleTask var1, BpmnElementContext var2);
    }

    private static final class JobWorkerTaskBehavior
    implements BusinessRuleTaskBehavior {
        private final JobWorkerTaskProcessor delegate;

        public JobWorkerTaskBehavior(BpmnBehaviors bpmnBehaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
            this.delegate = new JobWorkerTaskProcessor(bpmnBehaviors, stateTransitionBehavior);
        }

        @Override
        public void onActivate(ExecutableBusinessRuleTask element, BpmnElementContext activating) {
            this.delegate.onActivate(element, activating);
        }

        @Override
        public void onComplete(ExecutableBusinessRuleTask element, BpmnElementContext completing) {
            this.delegate.onComplete(element, completing);
        }

        @Override
        public void onTerminate(ExecutableBusinessRuleTask element, BpmnElementContext terminating) {
            this.delegate.onTerminate(element, terminating);
        }
    }
}

