/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.state.TypedEventApplier;
import io.camunda.zeebe.engine.state.appliers.EventSubProcessInterruptionMarker;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessState;
import io.camunda.zeebe.msgpack.value.DocumentValue;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessEventRecord;
import io.camunda.zeebe.protocol.record.intent.ProcessEventIntent;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

final class ProcessEventTriggeringApplier
implements TypedEventApplier<ProcessEventIntent, ProcessEventRecord> {
    private static final DirectBuffer NO_VARIABLES = new UnsafeBuffer();
    private final MutableEventScopeInstanceState eventScopeState;
    private final EventSubProcessInterruptionMarker eventSubProcessInterruptionMarker;

    public ProcessEventTriggeringApplier(MutableEventScopeInstanceState eventScopeState, MutableElementInstanceState elementInstanceState, MutableProcessState processState) {
        this.eventScopeState = eventScopeState;
        this.eventSubProcessInterruptionMarker = new EventSubProcessInterruptionMarker(processState, elementInstanceState);
    }

    @Override
    public void applyState(long key, ProcessEventRecord value) {
        DirectBuffer variables = value.getVariablesBuffer();
        if (variables.equals(DocumentValue.EMPTY_DOCUMENT)) {
            variables = NO_VARIABLES;
        }
        DirectBuffer targetElementIdBuffer = value.getTargetElementIdBuffer();
        long scopeKey = value.getScopeKey();
        long processInstanceKey = value.getProcessInstanceKey();
        if (value.getProcessDefinitionKey() == scopeKey) {
            this.eventScopeState.triggerStartEvent(scopeKey, key, targetElementIdBuffer, variables, processInstanceKey);
        } else {
            this.eventScopeState.triggerEvent(scopeKey, key, targetElementIdBuffer, variables, processInstanceKey);
        }
        this.eventSubProcessInterruptionMarker.markInstanceIfInterrupted(scopeKey, value.getProcessDefinitionKey(), value.getTenantId(), targetElementIdBuffer);
    }
}

