/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine;

import java.time.Duration;

public final class EngineConfiguration {
    public static final int DEFAULT_MESSAGES_TTL_CHECKER_BATCH_LIMIT = Integer.MAX_VALUE;
    public static final Duration DEFAULT_MESSAGES_TTL_CHECKER_INTERVAL = Duration.ofMinutes(1L);
    public static final int DEFAULT_MAX_ERROR_MESSAGE_SIZE = 10000;
    public static final int BATCH_SIZE_CALCULATION_BUFFER = 8192;
    public static final int DEFAULT_DRG_CACHE_CAPACITY = 1000;
    public static final Duration DEFAULT_JOBS_TIMEOUT_POLLING_INTERVAL = Duration.ofSeconds(1L);
    public static final int DEFAULT_JOBS_TIMEOUT_CHECKER_BATCH_LIMIT = Integer.MAX_VALUE;
    private int messagesTtlCheckerBatchLimit = Integer.MAX_VALUE;
    private Duration messagesTtlCheckerInterval = DEFAULT_MESSAGES_TTL_CHECKER_INTERVAL;
    private int drgCacheCapacity = 1000;
    private Duration jobsTimeoutCheckerPollingInterval = DEFAULT_JOBS_TIMEOUT_POLLING_INTERVAL;
    private int jobsTimeoutCheckerBatchLimit = Integer.MAX_VALUE;

    public int getMessagesTtlCheckerBatchLimit() {
        return this.messagesTtlCheckerBatchLimit;
    }

    public EngineConfiguration setMessagesTtlCheckerBatchLimit(int messagesTtlCheckerBatchLimit) {
        this.messagesTtlCheckerBatchLimit = messagesTtlCheckerBatchLimit;
        return this;
    }

    public Duration getMessagesTtlCheckerInterval() {
        return this.messagesTtlCheckerInterval;
    }

    public EngineConfiguration setMessagesTtlCheckerInterval(Duration messagesTtlCheckerInterval) {
        this.messagesTtlCheckerInterval = messagesTtlCheckerInterval;
        return this;
    }

    public int getDrgCacheCapacity() {
        return this.drgCacheCapacity;
    }

    public EngineConfiguration setDrgCacheCapacity(int drgCacheCapacity) {
        this.drgCacheCapacity = drgCacheCapacity;
        return this;
    }

    public Duration getJobsTimeoutCheckerPollingInterval() {
        return this.jobsTimeoutCheckerPollingInterval;
    }

    public EngineConfiguration setJobsTimeoutCheckerPollingInterval(Duration jobsTimeoutCheckerPollingInterval) {
        this.jobsTimeoutCheckerPollingInterval = jobsTimeoutCheckerPollingInterval;
        return this;
    }

    public int getJobsTimeoutCheckerBatchLimit() {
        return this.jobsTimeoutCheckerBatchLimit;
    }

    public EngineConfiguration setJobsTimeoutCheckerBatchLimit(int jobsTimeoutCheckerBatchLimit) {
        this.jobsTimeoutCheckerBatchLimit = jobsTimeoutCheckerBatchLimit;
        return this;
    }
}

