/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.auth.impl.TenantAuthorizationCheckerImpl;
import io.camunda.zeebe.engine.processing.deployment.model.element.AbstractFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableActivity;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableBoundaryEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableUserTask;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.EventScopeInstanceState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.instance.EventTrigger;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.BpmnEventType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceMigrationRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;

public final class ProcessInstanceMigrationPreconditionChecker {
    private static final EnumSet<BpmnElementType> SUPPORTED_ELEMENT_TYPES = EnumSet.of(BpmnElementType.PROCESS, BpmnElementType.SERVICE_TASK, BpmnElementType.USER_TASK, BpmnElementType.SUB_PROCESS);
    private static final Set<BpmnElementType> UNSUPPORTED_ELEMENT_TYPES = EnumSet.complementOf(SUPPORTED_ELEMENT_TYPES);
    private static final String ERROR_MESSAGE_PROCESS_INSTANCE_NOT_FOUND = "Expected to migrate process instance but no process instance found with key '%d'";
    private static final String ERROR_MESSAGE_PROCESS_DEFINITION_NOT_FOUND = "Expected to migrate process instance to process definition but no process definition found with key '%d'";
    private static final String ERROR_MESSAGE_DUPLICATE_SOURCE_ELEMENT_IDS = "Expected to migrate process instance '%s' but the mapping instructions contain duplicate source element ids '%s'.";
    private static final String ERROR_CHILD_PROCESS_INSTANCE = "Expected to migrate process instance '%s' but process instance is a child process instance. Child process instances cannot be migrated.";
    private static final String ERROR_SOURCE_ELEMENT_ID_NOT_FOUND = "Expected to migrate process instance '%s' but mapping instructions contain a non-existing source element id '%s'. Elements provided in mapping instructions must exist in the source process definition.";
    private static final String ERROR_TARGET_ELEMENT_ID_NOT_FOUND = "Expected to migrate process instance '%s' but mapping instructions contain a non-existing target element id '%s'. Elements provided in mapping instructions must exist in the target process definition.";
    private static final String ERROR_MESSAGE_EVENT_SUBPROCESS_NOT_SUPPORTED_IN_PROCESS_INSTANCE = "Expected to migrate process instance but process instance has an event subprocess. Process instances with event subprocesses cannot be migrated yet.";
    private static final String ERROR_MESSAGE_EVENT_SUBPROCESS_NOT_SUPPORTED_IN_TARGET_PROCESS = "Expected to migrate process instance but target process has an event subprocess. Target processes with event subprocesses cannot be migrated yet.";
    private static final String ERROR_UNSUPPORTED_ELEMENT_TYPE = "Expected to migrate process instance '%s' but active element with id '%s' has an unsupported type. The migration of a %s is not supported.";
    private static final String ERROR_UNMAPPED_ACTIVE_ELEMENT = "Expected to migrate process instance '%s' but no mapping instruction defined for active element with id '%s'. Elements cannot be migrated without a mapping.";
    private static final String ERROR_ELEMENT_TYPE_CHANGED = "Expected to migrate process instance '%s' but active element with id '%s' and type '%s' is mapped to an element with id '%s' and different type '%s'. Elements must be mapped to elements of the same type.";
    private static final String ERROR_USER_TASK_IMPLEMENTATION_CHANGED = "Expected to migrate process instance '%s' but active user task with id '%s' and implementation '%s' is mapped to an user task with id '%s' and different implementation '%s'. Elements must be mapped to elements of the same implementation.";
    private static final String ERROR_MESSAGE_ELEMENT_FLOW_SCOPE_CHANGED = "Expected to migrate process instance '%s' but the flow scope of active element with id '%s' is changed. The flow scope of the active element is expected to be '%s' but was '%s'. The flow scope of an element cannot be changed during migration yet.";
    private static final String ERROR_ACTIVE_ELEMENT_WITH_BOUNDARY_EVENT = "Expected to migrate process instance '%s' but active element with id '%s' has one or more boundary events of types '%s'. Migrating active elements with boundary events of these types is not possible yet.";
    private static final String ERROR_TARGET_ELEMENT_WITH_BOUNDARY_EVENT = "Expected to migrate process instance '%s' but target element with id '%s' has one or more boundary events of types '%s'. Migrating target elements with boundary events of these types is not possible yet.";
    private static final String ERROR_CONCURRENT_COMMAND = "Expected to migrate process instance '%s' but a concurrent command was executed on the process instance. Please retry the migration.";
    private static final long NO_PARENT = -1L;
    private static final String ZEEBE_USER_TASK_IMPLEMENTATION = "zeebe user task";
    private static final String JOB_WORKER_IMPLEMENTATION = "job worker";

    public static void requireNonNullProcessInstance(ElementInstance record, long processInstanceKey) {
        if (record == null) {
            String reason = String.format(ERROR_MESSAGE_PROCESS_INSTANCE_NOT_FOUND, processInstanceKey);
            throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.NOT_FOUND);
        }
    }

    public static void requireAuthorizedTenant(Map<String, Object> authorizations, String tenantId, long processInstanceKey) {
        boolean isTenantAuthorized = TenantAuthorizationCheckerImpl.fromAuthorizationMap(authorizations).isAuthorized(tenantId);
        if (!isTenantAuthorized) {
            String reason = String.format(ERROR_MESSAGE_PROCESS_INSTANCE_NOT_FOUND, processInstanceKey);
            throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.NOT_FOUND);
        }
    }

    public static void requireNullParent(long parentProcessInstanceKey, long processInstanceKey) {
        if (parentProcessInstanceKey != -1L) {
            String reason = String.format(ERROR_CHILD_PROCESS_INSTANCE, processInstanceKey);
            throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_STATE);
        }
    }

    public static void requireNonNullTargetProcessDefinition(DeployedProcess targetProcessDefinition, long targetProcessDefinitionKey) {
        if (targetProcessDefinition == null) {
            String reason = String.format(ERROR_MESSAGE_PROCESS_DEFINITION_NOT_FOUND, targetProcessDefinitionKey);
            throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.NOT_FOUND);
        }
    }

    public static void requireNonDuplicateSourceElementIds(List<ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue> mappingInstructions, long processInstanceKey) {
        Map<String, Long> countBySourceElementId = mappingInstructions.stream().collect(Collectors.groupingBy(ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue::getSourceElementId, Collectors.counting()));
        List<String> duplicateSourceElementIds = countBySourceElementId.entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).toList();
        if (!duplicateSourceElementIds.isEmpty()) {
            String reason = String.format(ERROR_MESSAGE_DUPLICATE_SOURCE_ELEMENT_IDS, processInstanceKey, duplicateSourceElementIds);
            throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_ARGUMENT);
        }
    }

    public static void requireReferredElementsExist(DeployedProcess sourceProcessDefinition, DeployedProcess targetProcessDefinition, List<ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue> mappingInstructions, long processInstanceKey) {
        mappingInstructions.forEach(instruction -> {
            String sourceElementId = instruction.getSourceElementId();
            if (sourceProcessDefinition.getProcess().getElementById(sourceElementId) == null) {
                String reason = String.format(ERROR_SOURCE_ELEMENT_ID_NOT_FOUND, processInstanceKey, sourceElementId);
                throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_ARGUMENT);
            }
            String targetElementId = instruction.getTargetElementId();
            if (targetProcessDefinition.getProcess().getElementById(targetElementId) == null) {
                String reason = String.format(ERROR_TARGET_ELEMENT_ID_NOT_FOUND, processInstanceKey, targetElementId);
                throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_ARGUMENT);
            }
        });
    }

    public static void requireNoEventSubprocess(DeployedProcess sourceProcessDefinition, DeployedProcess targetProcessDefinition) {
        if (!sourceProcessDefinition.getProcess().getEventSubprocesses().isEmpty()) {
            throw new ProcessInstanceMigrationPreconditionFailedException(ERROR_MESSAGE_EVENT_SUBPROCESS_NOT_SUPPORTED_IN_PROCESS_INSTANCE, RejectionType.INVALID_STATE);
        }
        if (!targetProcessDefinition.getProcess().getEventSubprocesses().isEmpty()) {
            throw new ProcessInstanceMigrationPreconditionFailedException(ERROR_MESSAGE_EVENT_SUBPROCESS_NOT_SUPPORTED_IN_TARGET_PROCESS, RejectionType.INVALID_STATE);
        }
    }

    public static void requireSupportedElementType(ProcessInstanceRecord elementInstanceRecord, long processInstanceKey) {
        if (UNSUPPORTED_ELEMENT_TYPES.contains(elementInstanceRecord.getBpmnElementType())) {
            String reason = String.format(ERROR_UNSUPPORTED_ELEMENT_TYPE, processInstanceKey, elementInstanceRecord.getElementId(), elementInstanceRecord.getBpmnElementType());
            throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_STATE);
        }
    }

    public static void requireNonNullTargetElementId(String targetElementId, long processInstanceKey, String sourceElementId) {
        if (targetElementId == null) {
            String reason = String.format(ERROR_UNMAPPED_ACTIVE_ELEMENT, processInstanceKey, sourceElementId);
            throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_STATE);
        }
    }

    public static void requireSameElementType(DeployedProcess targetProcessDefinition, String targetElementId, ProcessInstanceRecord elementInstanceRecord, long processInstanceKey) {
        BpmnElementType targetElementType = targetProcessDefinition.getProcess().getElementById(targetElementId).getElementType();
        if (elementInstanceRecord.getBpmnElementType() != targetElementType) {
            String reason = String.format(ERROR_ELEMENT_TYPE_CHANGED, processInstanceKey, elementInstanceRecord.getElementId(), elementInstanceRecord.getBpmnElementType(), targetElementId, targetElementType);
            throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_STATE);
        }
    }

    public static void requireSameUserTaskImplementation(DeployedProcess targetProcessDefinition, String targetElementId, ElementInstance elementInstance, long processInstanceKey) {
        String sourceUserTaskType;
        ProcessInstanceRecord elementInstanceRecord = elementInstance.getValue();
        if (elementInstanceRecord.getBpmnElementType() != BpmnElementType.USER_TASK) {
            return;
        }
        AbstractFlowElement targetElement = targetProcessDefinition.getProcess().getElementById(targetElementId);
        BpmnElementType targetElementType = targetElement.getElementType();
        if (targetElementType != BpmnElementType.USER_TASK) {
            return;
        }
        ExecutableUserTask targetUserTask = targetProcessDefinition.getProcess().getElementById(targetElementId, ExecutableUserTask.class);
        String targetUserTaskType = targetUserTask.getUserTaskProperties() != null ? ZEEBE_USER_TASK_IMPLEMENTATION : JOB_WORKER_IMPLEMENTATION;
        String string = sourceUserTaskType = elementInstance.getUserTaskKey() > 0L ? ZEEBE_USER_TASK_IMPLEMENTATION : JOB_WORKER_IMPLEMENTATION;
        if (!targetUserTaskType.equals(sourceUserTaskType)) {
            String reason = String.format(ERROR_USER_TASK_IMPLEMENTATION_CHANGED, processInstanceKey, elementInstanceRecord.getElementId(), sourceUserTaskType, targetElementId, targetUserTaskType);
            throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_STATE);
        }
    }

    public static void requireUnchangedFlowScope(ElementInstanceState elementInstanceState, ProcessInstanceRecord elementInstanceRecord, DeployedProcess targetProcessDefinition, String targetElementId) {
        DirectBuffer actualFlowScopeId;
        DirectBuffer expectedFlowScopeId;
        ElementInstance sourceFlowScopeElement = elementInstanceState.getInstance(elementInstanceRecord.getFlowScopeKey());
        if (sourceFlowScopeElement != null && !(expectedFlowScopeId = sourceFlowScopeElement.getValue().getElementIdBuffer()).equals((Object)(actualFlowScopeId = targetProcessDefinition.getProcess().getElementById(targetElementId).getFlowScope().getId()))) {
            String reason = String.format(ERROR_MESSAGE_ELEMENT_FLOW_SCOPE_CHANGED, elementInstanceRecord.getProcessInstanceKey(), elementInstanceRecord.getElementId(), BufferUtil.bufferAsString((DirectBuffer)expectedFlowScopeId), BufferUtil.bufferAsString((DirectBuffer)actualFlowScopeId));
            throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_STATE);
        }
    }

    public static void requireNoBoundaryEventInSource(DeployedProcess sourceProcessDefinition, ProcessInstanceRecord elementInstanceRecord, EnumSet<BpmnEventType> allowedEventTypes) {
        ProcessInstanceMigrationPreconditionChecker.requireNoBoundaryEvent(sourceProcessDefinition, elementInstanceRecord, elementInstanceRecord.getElementId(), allowedEventTypes, ERROR_ACTIVE_ELEMENT_WITH_BOUNDARY_EVENT);
    }

    public static void requireNoBoundaryEventInTarget(DeployedProcess targetProcessDefinition, String targetElementId, ProcessInstanceRecord elementInstanceRecord, EnumSet<BpmnEventType> allowedEventTypes) {
        ProcessInstanceMigrationPreconditionChecker.requireNoBoundaryEvent(targetProcessDefinition, elementInstanceRecord, targetElementId, allowedEventTypes, ERROR_TARGET_ELEMENT_WITH_BOUNDARY_EVENT);
    }

    private static void requireNoBoundaryEvent(DeployedProcess sourceProcessDefinition, ProcessInstanceRecord elementInstanceRecord, String elementId, EnumSet<BpmnEventType> allowedEventTypes, String errorTemplate) {
        List<ExecutableBoundaryEvent> boundaryEvents = sourceProcessDefinition.getProcess().getElementById(elementId, ExecutableActivity.class).getBoundaryEvents();
        List<ExecutableBoundaryEvent> rejectedBoundaryEvents = boundaryEvents.stream().filter(event -> !allowedEventTypes.contains(event.getEventType())).toList();
        if (!rejectedBoundaryEvents.isEmpty()) {
            String rejectedEventTypes = rejectedBoundaryEvents.stream().map(AbstractFlowElement::getEventType).map(Enum::name).collect(Collectors.joining(","));
            String reason = errorTemplate.formatted(elementInstanceRecord.getProcessInstanceKey(), elementId, rejectedEventTypes);
            throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_STATE);
        }
    }

    public static void requireNoConcurrentCommand(EventScopeInstanceState eventScopeInstanceState, ElementInstance elementInstance, long processInstanceKey) {
        EventTrigger eventTrigger = eventScopeInstanceState.peekEventTrigger(elementInstance.getKey());
        if (eventTrigger != null || elementInstance.getActiveSequenceFlows() > 0L) {
            String reason = String.format(ERROR_CONCURRENT_COMMAND, processInstanceKey);
            throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_STATE);
        }
    }

    public static void requireNoSubscriptionForMessage(boolean existSubscriptionForMessageName, ElementInstance elementInstance, DirectBuffer messageName, String targetCatchEventId) {
        if (existSubscriptionForMessageName) {
            long processInstanceKey = elementInstance.getValue().getProcessInstanceKey();
            String elementId = elementInstance.getValue().getElementId();
            String messageNameString = BufferUtil.bufferAsString((DirectBuffer)messageName);
            throw new ProcessInstanceMigrationPreconditionFailedException("Expected to migrate process instance '%s' but active element with id '%s' attempts to subscribe to a message it is already subscribed to with name '%s'. Migrating active elements that subscribe to a message they are already subscribed to is not possible yet. Please provide a mapping instruction to message catch event with id '%s' to migrate the respective message subscription.".formatted(processInstanceKey, elementId, messageNameString, targetCatchEventId), RejectionType.INVALID_STATE);
        }
    }

    public static void requireNoMappedCatchEventsInSource(Map<String, String> sourceElementIdToTargetElementId, String sourceCatchEventId, long processInstanceKey, String elementId) {
        if (sourceElementIdToTargetElementId.containsKey(sourceCatchEventId)) {
            throw new ProcessInstanceMigrationPreconditionFailedException("Expected to migrate process instance '%s' but active element with id '%s' is subscribed to mapped catch event with id '%s'. Migrating active elements with mapped catch events is not possible yet.".formatted(processInstanceKey, elementId, sourceCatchEventId), RejectionType.INVALID_STATE);
        }
    }

    public static void requireNoMappedCatchEventsInTarget(Map<String, String> sourceElementIdToTargetElementId, String targetCatchEventId, long processInstanceKey, String elementId, String targetElementId) {
        if (sourceElementIdToTargetElementId.containsValue(targetCatchEventId)) {
            throw new ProcessInstanceMigrationPreconditionFailedException("Expected to migrate process instance '%s' but active element with id '%s' is mapped to element with id '%s' that must be subscribed to mapped catch event with id '%s'. Migrating active elements with mapped catch events is not possible yet.".formatted(processInstanceKey, elementId, targetElementId, targetCatchEventId), RejectionType.INVALID_STATE);
        }
    }

    public static final class ProcessInstanceMigrationPreconditionFailedException
    extends RuntimeException {
        private final RejectionType rejectionType;

        public ProcessInstanceMigrationPreconditionFailedException(String message, RejectionType rejectionType) {
            super(message);
            this.rejectionType = rejectionType;
        }

        public RejectionType getRejectionType() {
            return this.rejectionType;
        }
    }
}

