/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.compensation;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.DbTenantAwareKey;
import io.camunda.zeebe.engine.state.compensation.CompensationSubscription;
import io.camunda.zeebe.engine.state.mutable.MutableCompensationSubscriptionState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.compensation.CompensationSubscriptionRecord;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class DbCompensationSubscriptionState
implements MutableCompensationSubscriptionState {
    private final DbLong processInstanceKey;
    private final DbLong recordKey;
    private final DbString tenantIdKey;
    private final DbTenantAwareKey<DbLong> tenantAwareProcessInstanceKey;
    private final DbCompositeKey<DbTenantAwareKey<DbLong>, DbLong> tenantAwareProcessInstanceKeyCompensableActivityId;
    private final ColumnFamily<DbCompositeKey<DbTenantAwareKey<DbLong>, DbLong>, CompensationSubscription> compensationSubscriptionColumnFamily;
    private final CompensationSubscription compensationSubscription = new CompensationSubscription();

    public DbCompensationSubscriptionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.processInstanceKey = new DbLong();
        this.recordKey = new DbLong();
        this.tenantIdKey = new DbString();
        this.tenantAwareProcessInstanceKey = new DbTenantAwareKey(this.tenantIdKey, (DbKey)this.processInstanceKey, DbTenantAwareKey.PlacementType.PREFIX);
        this.tenantAwareProcessInstanceKeyCompensableActivityId = new DbCompositeKey(this.tenantAwareProcessInstanceKey, (DbKey)this.recordKey);
        this.compensationSubscriptionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.COMPENSATION_SUBSCRIPTION, transactionContext, this.tenantAwareProcessInstanceKeyCompensableActivityId, (DbValue)this.compensationSubscription);
    }

    @Override
    public CompensationSubscription get(String tenantId, long processInstanceKey, long recordKey) {
        this.wrapCompensationKeys(processInstanceKey, recordKey, tenantId);
        return ((CompensationSubscription)this.compensationSubscriptionColumnFamily.get(this.tenantAwareProcessInstanceKeyCompensableActivityId)).copy();
    }

    @Override
    public List<CompensationSubscription> findSubscriptionsByProcessInstanceKey(String tenantId, long piKey) {
        this.tenantIdKey.wrapString(tenantId);
        this.processInstanceKey.wrapLong(piKey);
        ArrayList<CompensationSubscription> subscriptions = new ArrayList<CompensationSubscription>();
        this.compensationSubscriptionColumnFamily.whileEqualPrefix((DbKey)new DbCompositeKey((DbKey)this.tenantIdKey, (DbKey)this.processInstanceKey), (key, value) -> subscriptions.add(value.copy()));
        return subscriptions;
    }

    @Override
    public Optional<CompensationSubscription> findSubscriptionByCompensationHandlerId(String tenantId, long piKey, String compensationHandlerId) {
        this.tenantIdKey.wrapString(tenantId);
        this.processInstanceKey.wrapLong(piKey);
        ArrayList compensationSubscription = new ArrayList();
        this.compensationSubscriptionColumnFamily.whileEqualPrefix((DbKey)new DbCompositeKey((DbKey)this.tenantIdKey, (DbKey)this.processInstanceKey), (key, value) -> {
            if (value.getRecord().getCompensationHandlerId().equals(compensationHandlerId)) {
                compensationSubscription.add(value.copy());
            }
        });
        return compensationSubscription.stream().findFirst();
    }

    @Override
    public List<CompensationSubscription> findSubscriptionsByThrowEventInstanceKey(String tenantId, long piKey, long throwEventInstanceKey) {
        this.tenantIdKey.wrapString(tenantId);
        this.processInstanceKey.wrapLong(piKey);
        ArrayList<CompensationSubscription> compensations = new ArrayList<CompensationSubscription>();
        this.compensationSubscriptionColumnFamily.whileEqualPrefix((DbKey)new DbCompositeKey((DbKey)this.tenantIdKey, (DbKey)this.processInstanceKey), (key, value) -> {
            if (value.getRecord().getThrowEventInstanceKey() == throwEventInstanceKey) {
                compensations.add(value.copy());
            }
        });
        return compensations;
    }

    @Override
    public void put(long key, CompensationSubscriptionRecord compensation) {
        this.compensationSubscription.setKey(key).setRecord(compensation);
        this.wrapCompensationKeys(compensation.getProcessInstanceKey(), key, compensation.getTenantId());
        this.compensationSubscriptionColumnFamily.upsert(this.tenantAwareProcessInstanceKeyCompensableActivityId, (DbValue)this.compensationSubscription);
    }

    @Override
    public void update(long key, CompensationSubscriptionRecord compensation) {
        this.compensationSubscription.setKey(key).setRecord(compensation);
        this.wrapCompensationKeys(compensation.getProcessInstanceKey(), key, compensation.getTenantId());
        this.compensationSubscriptionColumnFamily.update(this.tenantAwareProcessInstanceKeyCompensableActivityId, (DbValue)this.compensationSubscription);
    }

    @Override
    public void delete(String tenantId, long processInstanceKey, long recordKey) {
        this.wrapCompensationKeys(processInstanceKey, recordKey, tenantId);
        this.compensationSubscriptionColumnFamily.deleteExisting(this.tenantAwareProcessInstanceKeyCompensableActivityId);
    }

    private void wrapCompensationKeys(long processInstance, long key, String tenantId) {
        this.processInstanceKey.wrapLong(processInstance);
        this.recordKey.wrapLong(key);
        this.tenantIdKey.wrapString(tenantId);
    }
}

