/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.signal;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.DbTenantAwareKey;
import io.camunda.zeebe.engine.state.immutable.SignalSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableSignalSubscriptionState;
import io.camunda.zeebe.engine.state.signal.SignalSubscription;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.signal.SignalSubscriptionRecord;
import org.agrona.DirectBuffer;

public final class DbSignalSubscriptionState
implements MutableSignalSubscriptionState {
    private final DbString signalName;
    private final DbLong subscriptionKey;
    private final DbString tenantIdKey;
    private final DbTenantAwareKey<DbString> tenantAwareSignalName;
    private final DbCompositeKey<DbTenantAwareKey<DbString>, DbLong> tenantAwareSignalNameAndSubscriptionKey;
    private final ColumnFamily<DbCompositeKey<DbTenantAwareKey<DbString>, DbLong>, SignalSubscription> signalNameAndSubscriptionKeyColumnFamily;
    private final SignalSubscription signalSubscription = new SignalSubscription();
    private final DbCompositeKey<DbLong, DbTenantAwareKey<DbString>> subscriptionKeyAndTenantAwareSignalName;
    private final ColumnFamily<DbCompositeKey<DbLong, DbTenantAwareKey<DbString>>, DbNil> subscriptionKeyAndSignalNameColumnFamily;

    public DbSignalSubscriptionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.signalName = new DbString();
        this.subscriptionKey = new DbLong();
        this.tenantIdKey = new DbString();
        this.tenantAwareSignalName = new DbTenantAwareKey(this.tenantIdKey, (DbKey)this.signalName, DbTenantAwareKey.PlacementType.PREFIX);
        this.tenantAwareSignalNameAndSubscriptionKey = new DbCompositeKey(this.tenantAwareSignalName, (DbKey)this.subscriptionKey);
        this.signalNameAndSubscriptionKeyColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.SIGNAL_SUBSCRIPTION_BY_NAME_AND_KEY, transactionContext, this.tenantAwareSignalNameAndSubscriptionKey, (DbValue)this.signalSubscription);
        this.subscriptionKeyAndTenantAwareSignalName = new DbCompositeKey((DbKey)this.subscriptionKey, this.tenantAwareSignalName);
        this.subscriptionKeyAndSignalNameColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.SIGNAL_SUBSCRIPTION_BY_KEY_AND_NAME, transactionContext, this.subscriptionKeyAndTenantAwareSignalName, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public void put(long key, SignalSubscriptionRecord subscription) {
        this.signalSubscription.setKey(key).setRecord(subscription);
        this.wrapSubscriptionKeys(subscription);
        this.signalNameAndSubscriptionKeyColumnFamily.upsert(this.tenantAwareSignalNameAndSubscriptionKey, (DbValue)this.signalSubscription);
        this.subscriptionKeyAndSignalNameColumnFamily.upsert(this.subscriptionKeyAndTenantAwareSignalName, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public void remove(long subscriptionKey, DirectBuffer signalName, String tenantId) {
        this.wrapSubscriptionKeys(subscriptionKey, signalName, tenantId);
        this.signalNameAndSubscriptionKeyColumnFamily.deleteExisting(this.tenantAwareSignalNameAndSubscriptionKey);
        this.subscriptionKeyAndSignalNameColumnFamily.deleteExisting(this.subscriptionKeyAndTenantAwareSignalName);
    }

    @Override
    public boolean exists(SignalSubscriptionRecord subscription) {
        this.wrapSubscriptionKeys(subscription);
        return this.signalNameAndSubscriptionKeyColumnFamily.exists(this.tenantAwareSignalNameAndSubscriptionKey);
    }

    @Override
    public void visitBySignalName(DirectBuffer signalName, String tenantId, SignalSubscriptionState.SignalSubscriptionVisitor visitor) {
        this.tenantIdKey.wrapString(tenantId);
        this.signalName.wrapBuffer(signalName);
        this.signalNameAndSubscriptionKeyColumnFamily.whileEqualPrefix(this.tenantAwareSignalName, (key, value) -> visitor.visit((SignalSubscription)((Object)value)));
    }

    @Override
    public void visitStartEventSubscriptionsByProcessDefinitionKey(long processDefinitionKey, SignalSubscriptionState.SignalSubscriptionVisitor visitor) {
        this.subscriptionKey.wrapLong(processDefinitionKey);
        this.visitSubscriptions(visitor);
    }

    @Override
    public void visitByElementInstanceKey(long elementInstanceKey, SignalSubscriptionState.SignalSubscriptionVisitor visitor) {
        this.subscriptionKey.wrapLong(elementInstanceKey);
        this.visitSubscriptions(visitor);
    }

    private void visitSubscriptions(SignalSubscriptionState.SignalSubscriptionVisitor visitor) {
        this.subscriptionKeyAndSignalNameColumnFamily.whileEqualPrefix((DbKey)this.subscriptionKey, (key, value) -> {
            this.signalName.wrapBuffer(((DbString)((DbTenantAwareKey)key.second()).wrappedKey()).getBuffer());
            this.tenantIdKey.wrapBuffer(((DbTenantAwareKey)key.second()).tenantKey().getBuffer());
            SignalSubscription subscription = (SignalSubscription)this.signalNameAndSubscriptionKeyColumnFamily.get(this.tenantAwareSignalNameAndSubscriptionKey);
            if (subscription != null) {
                visitor.visit(subscription);
            }
        });
    }

    private void wrapSubscriptionKeys(SignalSubscriptionRecord subscription) {
        long key = subscription.getSubscriptionKey();
        this.wrapSubscriptionKeys(key, subscription.getSignalNameBuffer(), subscription.getTenantId());
    }

    private void wrapSubscriptionKeys(long key, DirectBuffer signalName, String tenantId) {
        this.subscriptionKey.wrapLong(key);
        this.signalName.wrapBuffer(signalName);
        this.tenantIdKey.wrapString(tenantId);
    }
}

