/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableSequenceFlow;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.model.bpmn.instance.IntermediateCatchEvent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;

public final class IntermediateCatchEventTransformer
implements ModelElementTransformer<IntermediateCatchEvent> {
    @Override
    public Class<IntermediateCatchEvent> getType() {
        return IntermediateCatchEvent.class;
    }

    @Override
    public void transform(IntermediateCatchEvent element, TransformContext context) {
        ExecutableProcess process = context.getCurrentProcess();
        ExecutableCatchEventElement executableElement = process.getElementById(element.getId(), ExecutableCatchEventElement.class);
        boolean isConnectedToEventBasedGateway = executableElement.getIncoming().stream().map(ExecutableSequenceFlow::getSource).anyMatch(source -> source.getElementType() == BpmnElementType.EVENT_BASED_GATEWAY);
        executableElement.setConnectedToEventBasedGateway(isConnectedToEventBasedGateway);
    }
}

