/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.validation;

import io.camunda.zeebe.el.EvaluationResult;
import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.el.ResultType;
import io.camunda.zeebe.model.bpmn.instance.Message;
import io.camunda.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.Process;
import io.camunda.zeebe.model.bpmn.instance.StartEvent;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

final class ProcessMessageStartEventMessageNameValidator
implements ModelElementValidator<StartEvent> {
    private final ExpressionLanguage expressionLanguage;

    ProcessMessageStartEventMessageNameValidator(ExpressionLanguage expressionLanguage) {
        this.expressionLanguage = expressionLanguage;
    }

    public Class<StartEvent> getElementType() {
        return StartEvent.class;
    }

    public void validate(StartEvent element, ValidationResultCollector validationResultCollector) {
        if (element.getScope() instanceof Process) {
            element.getEventDefinitions().stream().filter(MessageEventDefinition.class::isInstance).map(MessageEventDefinition.class::cast).forEach(definition -> this.validateMessageName((MessageEventDefinition)definition, validationResultCollector));
        }
    }

    private void validateMessageName(MessageEventDefinition messageEventDefinition, ValidationResultCollector resultCollector) {
        Message message = messageEventDefinition.getMessage();
        if (message == null) {
            return;
        }
        String nameExpression = message.getName();
        if (nameExpression == null) {
            return;
        }
        Expression parseResult = this.expressionLanguage.parseExpression(nameExpression);
        EvaluationResult evaluationResult = this.expressionLanguage.evaluateExpression(parseResult, var -> null);
        if (evaluationResult.isFailure()) {
            resultCollector.addError(0, String.format("Expected constant expression but found '%s', which could not be evaluated without context: %s", nameExpression, evaluationResult.getFailureMessage()));
        } else if (evaluationResult.getType() != ResultType.STRING) {
            resultCollector.addError(0, String.format("Expected constant expression of type String for message name '%s', but was %s", nameExpression, evaluationResult.getType()));
        }
    }
}

