/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.state.immutable.VariableState;
import io.camunda.zeebe.msgpack.value.DocumentValue;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import java.util.Collection;
import org.agrona.DirectBuffer;

public class JobVariablesCollector {
    private final VariableState variableState;

    public JobVariablesCollector(VariableState variableState) {
        this.variableState = variableState;
    }

    public void setJobVariables(Collection<DirectBuffer> requestedVariables, JobRecord jobRecord) {
        long elementInstanceKey = jobRecord.getElementInstanceKey();
        if (elementInstanceKey >= 0L) {
            DirectBuffer variables = this.collectVariables(requestedVariables, elementInstanceKey);
            jobRecord.setVariables(variables);
        } else {
            jobRecord.setVariables(DocumentValue.EMPTY_DOCUMENT);
        }
    }

    private DirectBuffer collectVariables(Collection<DirectBuffer> variableNames, long elementInstanceKey) {
        DirectBuffer variables = variableNames.isEmpty() ? this.variableState.getVariablesAsDocument(elementInstanceKey) : this.variableState.getVariablesAsDocument(elementInstanceKey, variableNames);
        return variables;
    }
}

