/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.state.TypedEventApplier;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import java.util.concurrent.atomic.AtomicLong;

final class ProcessInstanceElementMigratedApplier
implements TypedEventApplier<ProcessInstanceIntent, ProcessInstanceRecord> {
    private final MutableElementInstanceState elementInstanceState;

    public ProcessInstanceElementMigratedApplier(MutableElementInstanceState elementInstanceState) {
        this.elementInstanceState = elementInstanceState;
    }

    @Override
    public void applyState(long elementInstanceKey, ProcessInstanceRecord value) {
        AtomicLong previousProcessDefinitionKey = new AtomicLong();
        this.elementInstanceState.updateInstance(elementInstanceKey, elementInstance -> {
            previousProcessDefinitionKey.set(elementInstance.getValue().getProcessDefinitionKey());
            elementInstance.getValue().setProcessDefinitionKey(value.getProcessDefinitionKey()).setBpmnProcessId(value.getBpmnProcessId()).setVersion(value.getVersion()).setElementId(value.getElementId()).setFlowScopeKey(value.getFlowScopeKey());
        });
        if (value.getBpmnElementType() == BpmnElementType.PROCESS) {
            this.elementInstanceState.deleteProcessInstanceKeyByDefinitionKey(value.getProcessInstanceKey(), previousProcessDefinitionKey.get());
            this.elementInstanceState.insertProcessInstanceKeyByDefinitionKey(value.getProcessInstanceKey(), value.getProcessDefinitionKey());
        }
    }
}

