/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.message;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.DbTenantAwareKey;
import io.camunda.zeebe.engine.state.immutable.MessageStartEventSubscriptionState;
import io.camunda.zeebe.engine.state.message.MessageStartEventSubscription;
import io.camunda.zeebe.engine.state.mutable.MutableMessageStartEventSubscriptionState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageStartEventSubscriptionRecord;
import org.agrona.DirectBuffer;

public final class DbMessageStartEventSubscriptionState
implements MutableMessageStartEventSubscriptionState {
    private final DbString tenantIdKey;
    private final DbString messageName;
    private final DbTenantAwareKey<DbString> tenantAwareMessageName;
    private final DbLong processDefinitionKey;
    private final DbCompositeKey<DbTenantAwareKey<DbString>, DbLong> messageNameAndProcessDefinitionKey;
    private final ColumnFamily<DbCompositeKey<DbTenantAwareKey<DbString>, DbLong>, MessageStartEventSubscription> subscriptionsColumnFamily;
    private final MessageStartEventSubscription messageStartEventSubscription = new MessageStartEventSubscription();
    private final DbCompositeKey<DbLong, DbTenantAwareKey<DbString>> processDefinitionKeyAndMessageName;
    private final ColumnFamily<DbCompositeKey<DbLong, DbTenantAwareKey<DbString>>, DbNil> subscriptionsOfProcessDefinitionKeyColumnFamily;

    public DbMessageStartEventSubscriptionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.tenantIdKey = new DbString();
        this.messageName = new DbString();
        this.tenantAwareMessageName = new DbTenantAwareKey(this.tenantIdKey, (DbKey)this.messageName, DbTenantAwareKey.PlacementType.PREFIX);
        this.processDefinitionKey = new DbLong();
        this.messageNameAndProcessDefinitionKey = new DbCompositeKey(this.tenantAwareMessageName, (DbKey)this.processDefinitionKey);
        this.subscriptionsColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_START_EVENT_SUBSCRIPTION_BY_NAME_AND_KEY, transactionContext, this.messageNameAndProcessDefinitionKey, (DbValue)this.messageStartEventSubscription);
        this.processDefinitionKeyAndMessageName = new DbCompositeKey((DbKey)this.processDefinitionKey, this.tenantAwareMessageName);
        this.subscriptionsOfProcessDefinitionKeyColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_START_EVENT_SUBSCRIPTION_BY_KEY_AND_NAME, transactionContext, this.processDefinitionKeyAndMessageName, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public void put(long key, MessageStartEventSubscriptionRecord subscription) {
        this.messageStartEventSubscription.setKey(key).setRecord(subscription);
        this.tenantIdKey.wrapString(subscription.getTenantId());
        this.messageName.wrapBuffer(subscription.getMessageNameBuffer());
        this.processDefinitionKey.wrapLong(subscription.getProcessDefinitionKey());
        this.subscriptionsColumnFamily.upsert(this.messageNameAndProcessDefinitionKey, (DbValue)this.messageStartEventSubscription);
        this.subscriptionsOfProcessDefinitionKeyColumnFamily.upsert(this.processDefinitionKeyAndMessageName, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public void remove(long processDefinitionKey, DirectBuffer messageName, String tenantId) {
        this.tenantIdKey.wrapString(tenantId);
        this.processDefinitionKey.wrapLong(processDefinitionKey);
        this.messageName.wrapBuffer(messageName);
        this.subscriptionsColumnFamily.deleteExisting(this.messageNameAndProcessDefinitionKey);
        this.subscriptionsOfProcessDefinitionKeyColumnFamily.deleteExisting(this.processDefinitionKeyAndMessageName);
    }

    @Override
    public boolean exists(MessageStartEventSubscriptionRecord subscription) {
        this.tenantIdKey.wrapString(subscription.getTenantId());
        this.messageName.wrapBuffer(subscription.getMessageNameBuffer());
        this.processDefinitionKey.wrapLong(subscription.getProcessDefinitionKey());
        return this.subscriptionsColumnFamily.exists(this.messageNameAndProcessDefinitionKey);
    }

    @Override
    public void visitSubscriptionsByMessageName(String tenantId, DirectBuffer messageName, MessageStartEventSubscriptionState.MessageStartEventSubscriptionVisitor visitor) {
        this.tenantIdKey.wrapString(tenantId);
        this.messageName.wrapBuffer(messageName);
        this.subscriptionsColumnFamily.whileEqualPrefix(this.tenantAwareMessageName, (key, value) -> visitor.visit((MessageStartEventSubscription)((Object)value)));
    }

    @Override
    public void visitSubscriptionsByProcessDefinition(long processDefinitionKey, MessageStartEventSubscriptionState.MessageStartEventSubscriptionVisitor visitor) {
        this.processDefinitionKey.wrapLong(processDefinitionKey);
        this.subscriptionsOfProcessDefinitionKeyColumnFamily.whileEqualPrefix((DbKey)this.processDefinitionKey, (key, value) -> {
            this.tenantIdKey.wrapBuffer(((DbTenantAwareKey)key.second()).tenantKey().getBuffer());
            MessageStartEventSubscription subscription = (MessageStartEventSubscription)this.subscriptionsColumnFamily.get(this.messageNameAndProcessDefinitionKey);
            if (subscription != null) {
                visitor.visit(subscription);
            }
        });
    }
}

