/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableActivity;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableBoundaryEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowNode;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableIntermediateThrowEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableLink;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableSequenceFlow;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import java.lang.runtime.SwitchBootstraps;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;

public class BpmnInclusiveGatewayBehavior {
    private final BpmnStateBehavior stateBehavior;

    public BpmnInclusiveGatewayBehavior(BpmnStateBehavior stateBehavior) {
        this.stateBehavior = stateBehavior;
    }

    public boolean hasActivePathToTheGateway(BpmnElementContext context, ExecutableFlowElement inclusiveGateway, ExecutableProcess process) {
        Set<DirectBuffer> takenSequenceFlowIds = this.stateBehavior.getTakenSequenceFlowIds(context);
        DirectBuffer gatewayElementId = inclusiveGateway.getId();
        Set<DirectBuffer> activateElementIds = this.findActivateElementInFlowScope(context, gatewayElementId);
        boolean hasActiveElementPath = activateElementIds.stream().anyMatch(elementId -> this.hasActivePathToTheGateway(process, (DirectBuffer)elementId, gatewayElementId, takenSequenceFlowIds));
        return hasActiveElementPath || this.hasActiveSequenceFlowToTheGateway(context, process, gatewayElementId, takenSequenceFlowIds);
    }

    private Set<DirectBuffer> findActivateElementInFlowScope(BpmnElementContext context, DirectBuffer targetElementId) {
        BpmnElementContext flowScopeContext = this.stateBehavior.getFlowScopeContext(context);
        List<BpmnElementContext> childInstanceContents = this.stateBehavior.getChildInstanceContexts(flowScopeContext);
        return childInstanceContents.stream().map(BpmnElementContext::getElementId).filter(elementId -> !elementId.equals((Object)targetElementId)).collect(Collectors.toSet());
    }

    private boolean hasActiveSequenceFlowToTheGateway(BpmnElementContext context, ExecutableProcess process, DirectBuffer targetElementId, Set<DirectBuffer> takenSequenceFlowIds) {
        ElementInstance flowScopeInstance = this.stateBehavior.getFlowScopeInstance(context);
        List<DirectBuffer> activeSequenceFlowIds = flowScopeInstance.getActiveSequenceFlowIds();
        return activeSequenceFlowIds.stream().anyMatch(flowId -> {
            DirectBuffer elementId = process.getElementById((DirectBuffer)flowId, ExecutableSequenceFlow.class).getTarget().getId();
            return !elementId.equals((Object)targetElementId) && this.hasActivePathToTheGateway(process, elementId, targetElementId, takenSequenceFlowIds);
        });
    }

    private boolean hasActivePathToTheGateway(ExecutableProcess process, DirectBuffer sourceElementId, DirectBuffer targetElementId, Set<DirectBuffer> takenSequenceFlowIds) {
        ExecutableFlowElement currentElement;
        HashSet<ExecutableFlowElement> visited = new HashSet<ExecutableFlowElement>();
        LinkedList<ExecutableFlowElement> elementsToVisit = new LinkedList<ExecutableFlowElement>();
        elementsToVisit.add(process.getElementById(sourceElementId));
        while ((currentElement = (ExecutableFlowElement)elementsToVisit.poll()) != null) {
            ExecutableFlowElement executableFlowElement;
            if (currentElement.getId().equals((Object)targetElementId)) {
                return true;
            }
            if (visited.contains(currentElement)) continue;
            visited.add(currentElement);
            Objects.requireNonNull(currentElement);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ExecutableIntermediateThrowEvent.class, ExecutableFlowNode.class}, (Object)executableFlowElement, n)) {
                case 0: {
                    ExecutableIntermediateThrowEvent throwEvent = (ExecutableIntermediateThrowEvent)executableFlowElement;
                    if (throwEvent.isLinkThrowEvent()) {
                        this.visitLinkEvent(elementsToVisit, throwEvent.getLink(), visited);
                        break;
                    }
                    this.visitElement(elementsToVisit, throwEvent, visited, takenSequenceFlowIds);
                    break;
                }
                case 1: {
                    ExecutableFlowNode element = (ExecutableFlowNode)executableFlowElement;
                    this.visitElement(elementsToVisit, element, visited, takenSequenceFlowIds);
                    break;
                }
            }
        }
        return false;
    }

    private void visitLinkEvent(Deque<ExecutableFlowElement> elementsToVisit, ExecutableLink linkThrowEvent, Set<ExecutableFlowElement> visited) {
        ExecutableCatchEventElement catchEventElement = linkThrowEvent.getCatchEventElement();
        if (catchEventElement != null && !visited.contains(catchEventElement)) {
            elementsToVisit.add(catchEventElement);
        }
    }

    private void visitElement(Deque<ExecutableFlowElement> elementsToVisit, ExecutableFlowNode sourceElement, Set<ExecutableFlowElement> visited, Set<DirectBuffer> takenSequenceFlowIds) {
        elementsToVisit.addAll(sourceElement.getOutgoing().stream().filter(sequenceFlow -> !takenSequenceFlowIds.contains(sequenceFlow.getId())).map(ExecutableSequenceFlow::getTarget).filter(target -> !visited.contains(target)).toList());
        if (sourceElement instanceof ExecutableActivity) {
            List<ExecutableBoundaryEvent> boundaryEvents = ((ExecutableActivity)sourceElement).getBoundaryEvents();
            boundaryEvents.stream().filter(e -> !visited.contains(e)).forEach(elementsToVisit::add);
        }
    }
}

