/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.common;

import io.camunda.zeebe.protocol.record.value.ErrorType;
import java.util.Objects;

public final class Failure {
    private final String message;
    private final ErrorType errorType;
    private final long variableScopeKey;

    public Failure(String message) {
        this.message = message;
        this.errorType = null;
        this.variableScopeKey = -1L;
    }

    public Failure(String message, ErrorType errorType) {
        this.message = message;
        this.errorType = errorType;
        this.variableScopeKey = -1L;
    }

    public Failure(String message, ErrorType errorType, long variableScopeKey) {
        this.message = message;
        this.errorType = errorType;
        this.variableScopeKey = variableScopeKey;
    }

    public String getMessage() {
        return this.message;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public long getVariableScopeKey() {
        return this.variableScopeKey;
    }

    public int hashCode() {
        return Objects.hash(this.message, this.errorType, this.variableScopeKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Failure failure = (Failure)o;
        return this.variableScopeKey == failure.variableScopeKey && Objects.equals(this.message, failure.message) && this.errorType == failure.errorType;
    }

    public String toString() {
        return "Failure{message='" + this.message + "', errorType=" + String.valueOf(this.errorType) + ", variableScopeKey=" + this.variableScopeKey + "}";
    }
}

