/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.transform;

import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.deployment.model.validation.ZeebeRuntimeValidators;
import io.camunda.zeebe.engine.processing.deployment.transform.ValidationErrorFormatter;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.traversal.ModelElementVisitor;
import io.camunda.zeebe.model.bpmn.traversal.ModelWalker;
import io.camunda.zeebe.model.bpmn.validation.ValidationVisitor;
import io.camunda.zeebe.model.bpmn.validation.zeebe.ZeebeDesignTimeValidators;
import java.io.StringWriter;
import org.camunda.bpm.model.xml.impl.validation.ModelValidationResultsImpl;
import org.camunda.bpm.model.xml.validation.ValidationResultFormatter;
import org.camunda.bpm.model.xml.validation.ValidationResults;

public final class BpmnValidator {
    private final ValidationVisitor designTimeAspectValidator;
    private final ValidationVisitor runtimeAspectValidator;
    private final ValidationErrorFormatter formatter = new ValidationErrorFormatter();
    private final int validatorResultsOutputMaxSize;

    public BpmnValidator(ExpressionLanguage expressionLanguage, ExpressionProcessor expressionProcessor, int validatorResultsOutputMaxSize) {
        this.designTimeAspectValidator = new ValidationVisitor(ZeebeDesignTimeValidators.VALIDATORS);
        this.runtimeAspectValidator = new ValidationVisitor(ZeebeRuntimeValidators.getValidators(expressionLanguage, expressionProcessor));
        this.validatorResultsOutputMaxSize = validatorResultsOutputMaxSize;
    }

    public String validate(BpmnModelInstance modelInstance) {
        this.designTimeAspectValidator.reset();
        this.runtimeAspectValidator.reset();
        ModelWalker walker = new ModelWalker(modelInstance);
        walker.walk((ModelElementVisitor)this.designTimeAspectValidator);
        walker.walk((ModelElementVisitor)this.runtimeAspectValidator);
        ValidationResults results1 = this.designTimeAspectValidator.getValidationResult();
        ValidationResults results2 = this.runtimeAspectValidator.getValidationResult();
        if (results1.hasErrors() || results2.hasErrors()) {
            StringWriter writer = new StringWriter();
            ModelValidationResultsImpl results = new ModelValidationResultsImpl(new ValidationResults[]{results1, results2});
            results.write(writer, (ValidationResultFormatter)this.formatter, this.validatorResultsOutputMaxSize);
            return writer.toString();
        }
        return null;
    }
}

