/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message;

import io.camunda.zeebe.protocol.impl.record.value.message.MessageStartEventSubscriptionRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.collection.Reusable;
import io.camunda.zeebe.util.collection.ReusableObjectList;
import java.util.Optional;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class Subscriptions {
    private final ReusableObjectList<Subscription> subscriptions = new ReusableObjectList(() -> new Subscription(this));

    public void clear() {
        this.subscriptions.clear();
    }

    public boolean contains(DirectBuffer bpmnProcessId) {
        for (Subscription subscription : this.subscriptions) {
            if (!subscription.getBpmnProcessId().equals((Object)bpmnProcessId)) continue;
            return true;
        }
        return false;
    }

    public void add(MessageSubscriptionRecord subscription) {
        Subscription newSubscription = (Subscription)this.subscriptions.add();
        newSubscription.setBpmnProcessId(BufferUtil.cloneBuffer((DirectBuffer)subscription.getBpmnProcessIdBuffer()));
        newSubscription.processInstanceKey = subscription.getProcessInstanceKey();
        newSubscription.elementInstanceKey = subscription.getElementInstanceKey();
    }

    public void add(MessageStartEventSubscriptionRecord subscription) {
        Subscription newSubscription = (Subscription)this.subscriptions.add();
        newSubscription.setBpmnProcessId(BufferUtil.cloneBuffer((DirectBuffer)subscription.getBpmnProcessIdBuffer()));
        newSubscription.isStartEventSubscription = true;
        newSubscription.processInstanceKey = subscription.getProcessInstanceKey();
    }

    private void add(Subscription subscription) {
        Subscription newSubscription = (Subscription)this.subscriptions.add();
        newSubscription.setBpmnProcessId(subscription.getBpmnProcessId());
        newSubscription.processInstanceKey = subscription.processInstanceKey;
        newSubscription.elementInstanceKey = subscription.elementInstanceKey;
        newSubscription.isStartEventSubscription = subscription.isStartEventSubscription;
    }

    public void addAll(Subscriptions subscriptions) {
        subscriptions.visitSubscriptions(subscription -> {
            this.add(subscription);
            return true;
        }, true);
    }

    public boolean isEmpty() {
        return this.subscriptions.size() <= 0;
    }

    public Optional<Subscription> getFirstMessageStartEventSubscription() {
        for (Subscription subscription : this.subscriptions) {
            if (!subscription.isStartEventSubscription) continue;
            return Optional.of(subscription);
        }
        return Optional.empty();
    }

    public boolean visitSubscriptions(SubscriptionVisitor subscriptionConsumer) {
        return this.visitSubscriptions(subscriptionConsumer, false);
    }

    public boolean visitSubscriptions(SubscriptionVisitor subscriptionConsumer, boolean visitStartEvents) {
        for (Subscription subscription : this.subscriptions) {
            boolean applied;
            if (!visitStartEvents && subscription.isStartEventSubscription || (applied = subscriptionConsumer.apply(subscription))) continue;
            return false;
        }
        return true;
    }

    public final class Subscription
    implements Reusable {
        private final MutableDirectBuffer bpmnProcessId = new ExpandableArrayBuffer();
        private final DirectBuffer bufferView = new UnsafeBuffer((DirectBuffer)this.bpmnProcessId);
        private int bufferLength = 0;
        private long processInstanceKey;
        private long elementInstanceKey;
        private boolean isStartEventSubscription;

        public Subscription(Subscriptions this$0) {
        }

        public void reset() {
            this.bufferLength = 0;
            this.bufferView.wrap(0L, 0);
            this.processInstanceKey = -1L;
            this.elementInstanceKey = -1L;
            this.isStartEventSubscription = false;
        }

        public DirectBuffer getBpmnProcessId() {
            return this.bufferView;
        }

        private void setBpmnProcessId(DirectBuffer bpmnProcessId) {
            this.bufferLength = bpmnProcessId.capacity();
            bpmnProcessId.getBytes(0, this.bpmnProcessId, 0, this.bufferLength);
            this.bufferView.wrap((DirectBuffer)this.bpmnProcessId, 0, this.bufferLength);
        }

        public long getProcessInstanceKey() {
            return this.processInstanceKey;
        }

        public long getElementInstanceKey() {
            return this.elementInstanceKey;
        }
    }

    @FunctionalInterface
    public static interface SubscriptionVisitor {
        public boolean apply(Subscription var1);
    }
}

