/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableActivity;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCompensation;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableEscalation;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableIntermediateThrowEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableLink;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableSignal;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.engine.processing.deployment.model.transformer.JobWorkerElementTransformer;
import io.camunda.zeebe.model.bpmn.instance.Activity;
import io.camunda.zeebe.model.bpmn.instance.CompensateEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.Escalation;
import io.camunda.zeebe.model.bpmn.instance.EscalationEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.EventDefinition;
import io.camunda.zeebe.model.bpmn.instance.IntermediateThrowEvent;
import io.camunda.zeebe.model.bpmn.instance.LinkEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.Signal;
import io.camunda.zeebe.model.bpmn.instance.SignalEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskDefinition;
import io.camunda.zeebe.protocol.record.value.BpmnEventType;

public final class IntermediateThrowEventTransformer
implements ModelElementTransformer<IntermediateThrowEvent> {
    private final JobWorkerElementTransformer<IntermediateThrowEvent> jobWorkerElementTransformer = new JobWorkerElementTransformer<IntermediateThrowEvent>(IntermediateThrowEvent.class);

    @Override
    public Class<IntermediateThrowEvent> getType() {
        return IntermediateThrowEvent.class;
    }

    @Override
    public void transform(IntermediateThrowEvent element, TransformContext context) {
        ExecutableProcess process = context.getCurrentProcess();
        ExecutableIntermediateThrowEvent throwEvent = process.getElementById(element.getId(), ExecutableIntermediateThrowEvent.class);
        throwEvent.setEventType(BpmnEventType.NONE);
        if (!element.getEventDefinitions().isEmpty()) {
            this.transformEventDefinition(element, context, throwEvent);
        }
    }

    private void transformEventDefinition(IntermediateThrowEvent element, TransformContext context, ExecutableIntermediateThrowEvent executableElement) {
        EventDefinition eventDefinition = (EventDefinition)element.getEventDefinitions().iterator().next();
        if (eventDefinition instanceof MessageEventDefinition) {
            executableElement.setEventType(BpmnEventType.MESSAGE);
            if (this.hasTaskDefinition(element)) {
                this.jobWorkerElementTransformer.transform(element, context);
            }
        } else if (eventDefinition instanceof LinkEventDefinition) {
            LinkEventDefinition linkEventDefinition = (LinkEventDefinition)eventDefinition;
            this.transformLinkEventDefinition(context, executableElement, linkEventDefinition);
        } else if (eventDefinition instanceof EscalationEventDefinition) {
            EscalationEventDefinition escalationEventDefinition = (EscalationEventDefinition)eventDefinition;
            this.transformEscalationEventDefinition(context, executableElement, escalationEventDefinition);
        } else if (eventDefinition instanceof SignalEventDefinition) {
            SignalEventDefinition signalEventDefinition = (SignalEventDefinition)eventDefinition;
            this.transformSignalEventDefinition(context, executableElement, signalEventDefinition);
        } else if (eventDefinition instanceof CompensateEventDefinition) {
            CompensateEventDefinition compensateEventDefinition = (CompensateEventDefinition)eventDefinition;
            this.transformCompensationEventDefinition(context, executableElement, compensateEventDefinition);
        }
    }

    private boolean hasTaskDefinition(IntermediateThrowEvent element) {
        return element.getSingleExtensionElement(ZeebeTaskDefinition.class) != null;
    }

    private void transformLinkEventDefinition(TransformContext context, ExecutableIntermediateThrowEvent executableThrowEventElement, LinkEventDefinition eventDefinition) {
        String name = eventDefinition.getName();
        ExecutableLink executableLink = context.getLink(name);
        executableThrowEventElement.setLink(executableLink);
        executableThrowEventElement.setEventType(BpmnEventType.LINK);
    }

    private void transformEscalationEventDefinition(TransformContext context, ExecutableIntermediateThrowEvent executableElement, EscalationEventDefinition eventDefinition) {
        Escalation escalation = eventDefinition.getEscalation();
        ExecutableEscalation executableEscalation = context.getEscalation(escalation.getId());
        executableElement.setEscalation(executableEscalation);
        executableElement.setEventType(BpmnEventType.ESCALATION);
    }

    private void transformSignalEventDefinition(TransformContext context, ExecutableIntermediateThrowEvent executableElement, SignalEventDefinition eventDefinition) {
        Signal signal = eventDefinition.getSignal();
        ExecutableSignal executableSignal = context.getSignal(signal.getId());
        executableElement.setSignal(executableSignal);
        executableElement.setEventType(BpmnEventType.SIGNAL);
    }

    private void transformCompensationEventDefinition(TransformContext context, ExecutableIntermediateThrowEvent executableElement, CompensateEventDefinition eventDefinition) {
        ExecutableCompensation compensation = new ExecutableCompensation(eventDefinition.getId());
        Activity activityRef = eventDefinition.getActivity();
        if (activityRef != null) {
            ExecutableActivity activity = context.getCurrentProcess().getElementById(activityRef.getId(), ExecutableActivity.class);
            compensation.setReferenceCompensationActivity(activity);
        }
        executableElement.setCompensation(compensation);
        executableElement.setEventType(BpmnEventType.COMPENSATION);
    }
}

