/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.authorization;

import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.msgpack.property.ArrayProperty;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.value.StringValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class ResourceIdentifiers
extends UnpackedObject
implements DbValue {
    private final ArrayProperty<StringValue> resourceIds = new ArrayProperty("resourceIds", StringValue::new);

    public ResourceIdentifiers() {
        super(1);
        this.declareProperty((BaseProperty)this.resourceIds);
    }

    public ResourceIdentifiers copy() {
        ResourceIdentifiers copy = new ResourceIdentifiers();
        copy.setResourceIdentifiers(this.getResourceIdentifiers());
        return copy;
    }

    public List<String> getResourceIdentifiers() {
        return StreamSupport.stream(this.resourceIds.spliterator(), false).map(StringValue::getValue).map(BufferUtil::bufferAsString).collect(Collectors.toList());
    }

    public void setResourceIdentifiers(List<String> permissions) {
        this.resourceIds.reset();
        permissions.forEach(permission -> ((StringValue)this.resourceIds.add()).wrap(BufferUtil.wrapString((String)permission)));
    }

    public void addResourceIdentifiers(List<String> resourceIdentifiers) {
        resourceIdentifiers.forEach(resourceIdentifier -> ((StringValue)this.resourceIds.add()).wrap(BufferUtil.wrapString((String)resourceIdentifier)));
    }
}

