/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.api.Result;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventListener;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestRunStarted;
import cucumber.api.event.TestStepFinished;
import cucumber.runtime.formatter.AnsiFormats;
import cucumber.runtime.formatter.Format;
import cucumber.runtime.formatter.Formats;
import cucumber.runtime.formatter.MonochromeFormats;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

class Stats
implements EventListener {
    public static final long ONE_SECOND = 1000000000L;
    public static final long ONE_MINUTE = 60000000000L;
    private static final byte ERRORS = 1;
    private SubCounts scenarioSubCounts = new SubCounts();
    private SubCounts stepSubCounts = new SubCounts();
    private long startTime = 0L;
    private long totalDuration = 0L;
    private Formats formats;
    private Locale locale;
    private final List<String> failedScenarios = new ArrayList<String>();
    private List<String> ambiguousScenarios = new ArrayList<String>();
    private final List<String> pendingScenarios = new ArrayList<String>();
    private final List<String> undefinedScenarios = new ArrayList<String>();
    private final List<Throwable> errors = new ArrayList<Throwable>();
    private final EventHandler<TestRunStarted> testRunStartedHandler = new EventHandler<TestRunStarted>(){

        @Override
        public void receive(TestRunStarted event) {
            Stats.this.setStartTime(event.getTimeStamp());
        }
    };
    private final EventHandler<TestStepFinished> stepFinishedHandler = new EventHandler<TestStepFinished>(){

        @Override
        public void receive(TestStepFinished event) {
            Result result = event.result;
            if (result.getError() != null) {
                Stats.this.addError(result.getError());
            }
            if (!event.testStep.isHook()) {
                Stats.this.addStep(result.getStatus());
            }
        }
    };
    private final EventHandler<TestCaseFinished> testCaseFinishedHandler = new EventHandler<TestCaseFinished>(){

        @Override
        public void receive(TestCaseFinished event) {
            Stats.this.addScenario(event.result.getStatus(), event.testCase.getScenarioDesignation());
        }
    };
    private final EventHandler<TestRunFinished> testRunFinishedHandler = new EventHandler<TestRunFinished>(){

        @Override
        public void receive(TestRunFinished event) {
            Stats.this.setFinishTime(event.getTimeStamp());
        }
    };

    public Stats(boolean monochrome) {
        this(monochrome, Locale.getDefault());
    }

    public Stats(boolean monochrome, Locale locale) {
        this.locale = locale;
        this.formats = monochrome ? new MonochromeFormats() : new AnsiFormats();
    }

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestRunStarted.class, this.testRunStartedHandler);
        publisher.registerHandlerFor(TestStepFinished.class, this.stepFinishedHandler);
        publisher.registerHandlerFor(TestCaseFinished.class, this.testCaseFinishedHandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.testRunFinishedHandler);
    }

    public List<Throwable> getErrors() {
        return this.errors;
    }

    public byte exitStatus(boolean isStrict) {
        byte result = 0;
        if (!this.failedScenarios.isEmpty() || isStrict && (!this.pendingScenarios.isEmpty() || !this.undefinedScenarios.isEmpty())) {
            result = (byte)(result | 1);
        }
        return result;
    }

    public void printStats(PrintStream out, boolean isStrict) {
        this.printNonZeroResultScenarios(out, isStrict);
        if (this.stepSubCounts.getTotal() == 0) {
            out.println("0 Scenarios");
            out.println("0 Steps");
        } else {
            this.printScenarioCounts(out);
            this.printStepCounts(out);
        }
        this.printDuration(out);
    }

    private void printStepCounts(PrintStream out) {
        out.print(this.stepSubCounts.getTotal());
        out.print(" Steps (");
        this.printSubCounts(out, this.stepSubCounts);
        out.println(")");
    }

    private void printScenarioCounts(PrintStream out) {
        out.print(this.scenarioSubCounts.getTotal());
        out.print(" Scenarios (");
        this.printSubCounts(out, this.scenarioSubCounts);
        out.println(")");
    }

    private void printSubCounts(PrintStream out, SubCounts subCounts) {
        boolean addComma = false;
        addComma = this.printSubCount(out, subCounts.failed, Result.Type.FAILED, addComma);
        addComma = this.printSubCount(out, subCounts.ambiguous, Result.Type.AMBIGUOUS, addComma);
        addComma = this.printSubCount(out, subCounts.skipped, Result.Type.SKIPPED, addComma);
        addComma = this.printSubCount(out, subCounts.pending, Result.Type.PENDING, addComma);
        addComma = this.printSubCount(out, subCounts.undefined, Result.Type.UNDEFINED, addComma);
        addComma = this.printSubCount(out, subCounts.passed, Result.Type.PASSED, addComma);
    }

    private boolean printSubCount(PrintStream out, int count, Result.Type type, boolean addComma) {
        if (count != 0) {
            if (addComma) {
                out.print(", ");
            }
            Format format = this.formats.get(type.lowerCaseName());
            out.print(format.text(count + " " + type.lowerCaseName()));
            addComma = true;
        }
        return addComma;
    }

    private void printDuration(PrintStream out) {
        out.print(String.format("%dm", this.totalDuration / 60000000000L));
        DecimalFormat format = new DecimalFormat("0.000", new DecimalFormatSymbols(this.locale));
        out.println(format.format((double)(this.totalDuration % 60000000000L) / 1.0E9) + "s");
    }

    private void printNonZeroResultScenarios(PrintStream out, boolean isStrict) {
        this.printScenarios(out, this.failedScenarios, Result.Type.FAILED);
        this.printScenarios(out, this.ambiguousScenarios, Result.Type.AMBIGUOUS);
        if (isStrict) {
            this.printScenarios(out, this.pendingScenarios, Result.Type.PENDING);
            this.printScenarios(out, this.undefinedScenarios, Result.Type.UNDEFINED);
        }
    }

    private void printScenarios(PrintStream out, List<String> scenarios, Result.Type type) {
        Format format = this.formats.get(type.lowerCaseName());
        if (!scenarios.isEmpty()) {
            out.println(format.text(type.firstLetterCapitalizedName() + " scenarios:"));
        }
        for (String scenario : scenarios) {
            String[] parts = scenario.split("#");
            out.print(format.text(parts[0]));
            for (int i = 1; i < parts.length; ++i) {
                out.println("#" + parts[i]);
            }
        }
        if (!scenarios.isEmpty()) {
            out.println();
        }
    }

    void addStep(Result.Type resultStatus) {
        this.addResultToSubCount(this.stepSubCounts, resultStatus);
    }

    private void addError(Throwable error) {
        this.errors.add(error);
    }

    void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    void setFinishTime(Long finishTime) {
        this.totalDuration = finishTime - this.startTime;
    }

    private void addResultToSubCount(SubCounts subCounts, Result.Type resultStatus) {
        switch (resultStatus) {
            case FAILED: {
                ++subCounts.failed;
                break;
            }
            case AMBIGUOUS: {
                ++subCounts.ambiguous;
                break;
            }
            case PENDING: {
                ++subCounts.pending;
                break;
            }
            case UNDEFINED: {
                ++subCounts.undefined;
                break;
            }
            case SKIPPED: {
                ++subCounts.skipped;
                break;
            }
            default: {
                ++subCounts.passed;
            }
        }
    }

    void addScenario(Result.Type resultStatus, String scenarioDesignation) {
        this.addResultToSubCount(this.scenarioSubCounts, resultStatus);
        switch (resultStatus) {
            case FAILED: {
                this.failedScenarios.add(scenarioDesignation);
                break;
            }
            case AMBIGUOUS: {
                this.ambiguousScenarios.add(scenarioDesignation);
                break;
            }
            case PENDING: {
                this.pendingScenarios.add(scenarioDesignation);
                break;
            }
            case UNDEFINED: {
                this.undefinedScenarios.add(scenarioDesignation);
                break;
            }
        }
    }

    static class SubCounts {
        public int passed = 0;
        public int failed = 0;
        public int ambiguous = 0;
        public int skipped = 0;
        public int pending = 0;
        public int undefined = 0;

        SubCounts() {
        }

        public int getTotal() {
            return this.passed + this.failed + this.ambiguous + this.skipped + this.pending + this.undefined;
        }
    }
}

