/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.xstream;

import cucumber.deps.com.thoughtworks.xstream.converters.ConversionException;
import cucumber.runtime.xstream.ConverterWithFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

class ConverterWithEnumFormat<T extends Enum>
extends ConverterWithFormat<T> {
    private final List<Format> formats = new ArrayList<Format>();
    private final Locale locale;
    private final Class<? extends Enum> typeClass;

    ConverterWithEnumFormat(Locale locale, Class<? extends Enum> enumClass) {
        super(new Class[]{enumClass});
        this.locale = locale;
        this.typeClass = enumClass;
        this.formats.add(new OriginalFormat());
        this.formats.add(new LowercaseFormat());
        this.formats.add(new UppercaseFormat());
        this.formats.add(new CapitalizeFormat());
    }

    @Override
    public T transform(String string) {
        try {
            return (T)((Enum)super.transform(string));
        }
        catch (ConversionException e) {
            String allowed = Arrays.asList(this.typeClass.getEnumConstants()).toString();
            throw new ConversionException(String.format("Couldn't convert %s to %s. Legal values are %s", string, this.typeClass.getName(), allowed));
        }
    }

    @Override
    public List<Format> getFormats() {
        return this.formats;
    }

    private abstract class AbstractEnumFormat
    extends Format {
        private AbstractEnumFormat() {
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(String.valueOf(obj));
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return source == null ? null : Enum.valueOf(ConverterWithEnumFormat.this.typeClass, this.transformSource(source));
        }

        protected abstract String transformSource(String var1);
    }

    private class CapitalizeFormat
    extends AbstractEnumFormat {
        private CapitalizeFormat() {
        }

        @Override
        protected String transformSource(String source) {
            String firstLetter = source.substring(0, 1);
            String restOfTheString = source.substring(1, source.length());
            return firstLetter.toUpperCase(ConverterWithEnumFormat.this.locale) + restOfTheString;
        }
    }

    private class UppercaseFormat
    extends AbstractEnumFormat {
        private UppercaseFormat() {
        }

        @Override
        protected String transformSource(String source) {
            return source.toUpperCase(ConverterWithEnumFormat.this.locale);
        }
    }

    private class LowercaseFormat
    extends AbstractEnumFormat {
        private LowercaseFormat() {
        }

        @Override
        protected String transformSource(String source) {
            return source.toLowerCase(ConverterWithEnumFormat.this.locale);
        }
    }

    private class OriginalFormat
    extends AbstractEnumFormat {
        private OriginalFormat() {
        }

        @Override
        protected String transformSource(String source) {
            return source;
        }
    }
}

