/*
 * Decompiled with CFR 0.152.
 */
package cucumber.api;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Comparator;
import java.util.Objects;

public final class Result {
    public static final Comparator<Result> SEVERITY = new Comparator<Result>(){

        @Override
        public int compare(Result a, Result b) {
            return a.status == b.status ? 0 : (a.status.ordinal() > b.status.ordinal() ? 1 : -1);
        }
    };
    private final Type status;
    private final Long duration;
    private final Throwable error;
    public static final Result UNDEFINED = new Result(Type.UNDEFINED, 0L, null);

    public Result(Type status, Long duration, Throwable error) {
        this.status = Objects.requireNonNull(status);
        this.duration = Objects.requireNonNull(duration);
        this.error = error;
    }

    public Type getStatus() {
        return this.status;
    }

    public Long getDuration() {
        return this.duration;
    }

    public String getErrorMessage() {
        return this.error != null ? this.getErrorMessage(this.error) : null;
    }

    public Throwable getError() {
        return this.error;
    }

    public boolean is(Type status) {
        return this.status == status;
    }

    public boolean isOk(boolean isStrict) {
        return this.hasAlwaysOkStatus() || !isStrict && this.hasOkWhenNotStrictStatus();
    }

    private boolean hasAlwaysOkStatus() {
        return this.is(Type.PASSED) || this.is(Type.SKIPPED);
    }

    private boolean hasOkWhenNotStrictStatus() {
        return this.is(Type.UNDEFINED) || this.is(Type.PENDING);
    }

    private String getErrorMessage(Throwable error) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        error.printStackTrace(printWriter);
        return stringWriter.getBuffer().toString();
    }

    public String toString() {
        return "Result{status=" + (Object)((Object)this.status) + ", duration=" + this.duration + ", error=" + this.error + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Result result = (Result)o;
        return this.status == result.status && Objects.equals(this.duration, result.duration) && Objects.equals(this.error, result.error);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.duration, this.error});
    }

    public static enum Type {
        PASSED,
        SKIPPED,
        PENDING,
        UNDEFINED,
        AMBIGUOUS,
        FAILED;


        public static Type fromLowerCaseName(String lowerCaseName) {
            return Type.valueOf(lowerCaseName.toUpperCase());
        }

        public String lowerCaseName() {
            return this.name().toLowerCase();
        }

        public String firstLetterCapitalizedName() {
            return this.name().substring(0, 1) + this.name().substring(1).toLowerCase();
        }
    }
}

