/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.model;

import cucumber.runtime.io.Resource;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.FeatureBuilder;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

public final class FeatureLoader {
    private static final String FEATURE_SUFFIX = ".feature";
    private final ResourceLoader resourceLoader;

    public FeatureLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public List<CucumberFeature> load(List<String> featurePaths, PrintStream out) {
        List<CucumberFeature> cucumberFeatures = this.load(featurePaths);
        if (cucumberFeatures.isEmpty()) {
            if (featurePaths.isEmpty()) {
                out.println("Got no path to feature directory or feature file");
            } else {
                out.println(String.format("No features found at %s", featurePaths));
            }
        }
        return cucumberFeatures;
    }

    public List<CucumberFeature> load(List<String> featurePaths) {
        FeatureBuilder builder = new FeatureBuilder();
        for (String featurePath : featurePaths) {
            this.loadFromFeaturePath(builder, featurePath);
        }
        return builder.build();
    }

    private void loadFromFeaturePath(FeatureBuilder builder, String featurePath) {
        Iterable<Resource> resources = this.resourceLoader.resources(featurePath, FEATURE_SUFFIX);
        Iterator<Resource> iterator = resources.iterator();
        if (featurePath.endsWith(FEATURE_SUFFIX) && !iterator.hasNext()) {
            throw new IllegalArgumentException("Feature not found: " + featurePath);
        }
        while (iterator.hasNext()) {
            builder.parse(iterator.next());
        }
    }
}

