/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runner;

import io.cucumber.core.backend.HookDefinition;
import io.cucumber.core.backend.ScenarioScoped;
import io.cucumber.core.backend.TestCaseState;
import io.cucumber.tagexpressions.Expression;
import io.cucumber.tagexpressions.TagExpressionParser;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

class CoreHookDefinition {
    private final UUID id;
    private final HookDefinition delegate;
    private final Expression tagExpression;

    private CoreHookDefinition(UUID id, HookDefinition delegate) {
        this.id = Objects.requireNonNull(id);
        this.delegate = delegate;
        this.tagExpression = new TagExpressionParser().parse(delegate.getTagExpression());
    }

    static CoreHookDefinition create(HookDefinition hookDefinition) {
        if (hookDefinition instanceof ScenarioScoped) {
            return new ScenarioScopedCoreHookDefinition(hookDefinition);
        }
        return new CoreHookDefinition(UUID.randomUUID(), hookDefinition);
    }

    void execute(TestCaseState scenario) {
        this.delegate.execute(scenario);
    }

    HookDefinition getDelegate() {
        return this.delegate;
    }

    String getLocation() {
        return this.delegate.getLocation();
    }

    UUID getId() {
        return this.id;
    }

    int getOrder() {
        return this.delegate.getOrder();
    }

    boolean matches(List<String> tags) {
        return this.tagExpression.evaluate(tags);
    }

    String getTagExpression() {
        return this.delegate.getTagExpression();
    }

    static class ScenarioScopedCoreHookDefinition
    extends CoreHookDefinition
    implements ScenarioScoped {
        private ScenarioScopedCoreHookDefinition(HookDefinition delegate) {
            super(UUID.randomUUID(), delegate);
        }
    }
}

