/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.plugin.UTF8OutputStreamWriter;
import io.cucumber.htmlformatter.MessagesToHtmlWriter;
import io.cucumber.messages.Messages;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.EventPublisher;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public final class HtmlFormatter
implements ConcurrentEventListener {
    private final MessagesToHtmlWriter writer;

    public HtmlFormatter(OutputStream out) throws IOException {
        this.writer = new MessagesToHtmlWriter((Writer)new UTF8OutputStreamWriter(out));
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(Messages.Envelope.class, this::write);
    }

    private void write(Messages.Envelope event) {
        try {
            this.writer.write(event);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (event.hasTestRunFinished()) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

