/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.Gherkin;
import io.cucumber.gherkin.GherkinException;
import io.cucumber.messages.IdGenerator;
import io.cucumber.messages.MessageToBinaryWriter;
import io.cucumber.messages.MessageToNdjsonWriter;
import io.cucumber.messages.MessageWriter;
import io.cucumber.messages.Messages;
import io.cucumber.messages.internal.com.google.protobuf.GeneratedMessageV3;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;

public class Main {
    public static void main(String[] argv) {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(argv));
        ArrayList<String> paths = new ArrayList<String>();
        boolean includeSource = true;
        boolean includeAst = true;
        boolean includePickles = true;
        String format = "protobuf";
        IdGenerator.UUID idGenerator = null;
        block14: while (!args.isEmpty()) {
            String arg;
            switch (arg = ((String)args.remove(0)).trim()) {
                case "--no-source": {
                    includeSource = false;
                    continue block14;
                }
                case "--no-ast": {
                    includeAst = false;
                    continue block14;
                }
                case "--no-pickles": {
                    includePickles = false;
                    continue block14;
                }
                case "--format": {
                    format = ((String)args.remove(0)).trim();
                    continue block14;
                }
                case "--predictable-ids": {
                    idGenerator = new IdGenerator.Incrementing();
                    continue block14;
                }
            }
            paths.add(arg);
        }
        if (idGenerator == null) {
            idGenerator = new IdGenerator.UUID();
        }
        MessageWriter messageWriter = Main.makeMessageWriter(format);
        Stream<Messages.Envelope> messages = paths.isEmpty() ? Gherkin.fromStream(System.in) : Gherkin.fromPaths(paths, includeSource, includeAst, includePickles, (IdGenerator)idGenerator);
        Main.printMessages(messageWriter, messages);
    }

    private static void printMessages(MessageWriter messageWriter, Stream<Messages.Envelope> messages) {
        messages.forEach(envelope -> {
            try {
                messageWriter.write((GeneratedMessageV3)envelope);
            }
            catch (IOException e) {
                throw new GherkinException("Couldn't print messages", e);
            }
        });
    }

    private static MessageWriter makeMessageWriter(String format) {
        MessageToNdjsonWriter messageWriter;
        switch (format) {
            case "ndjson": {
                messageWriter = new MessageToNdjsonWriter((OutputStream)System.out);
                break;
            }
            case "protobuf": {
                messageWriter = new MessageToBinaryWriter((OutputStream)System.out);
                break;
            }
            default: {
                throw new Error(String.format("Unsupported format: %s", format));
            }
        }
        return messageWriter;
    }
}

