/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.options;

import io.cucumber.core.options.ShellWords;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class CurlOption {
    private final Proxy proxy;
    private final URI uri;
    private final HttpMethod method;
    private final List<Map.Entry<String, String>> headers;

    private CurlOption(Proxy proxy, HttpMethod method, URI uri, List<Map.Entry<String, String>> headers) {
        this.proxy = Objects.requireNonNull(proxy);
        this.uri = Objects.requireNonNull(uri);
        this.method = Objects.requireNonNull(method);
        this.headers = Objects.requireNonNull(headers);
    }

    @SafeVarargs
    public static CurlOption create(HttpMethod method, URI uri, Map.Entry<String, String> ... headers) {
        return new CurlOption(Proxy.NO_PROXY, method, uri, Arrays.asList(headers));
    }

    public static CurlOption parse(String cmdLine) {
        List<String> args = ShellWords.parse(cmdLine);
        URI url = null;
        HttpMethod method = HttpMethod.PUT;
        ArrayList<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();
        Proxy proxy = Proxy.NO_PROXY;
        while (!args.isEmpty()) {
            String arg = args.remove(0);
            if (arg.equals("-X")) {
                String methodArg = CurlOption.removeArgFor(arg, args);
                method = HttpMethod.parse(methodArg);
                continue;
            }
            if (arg.equals("-H")) {
                String headerArg = CurlOption.removeArgFor(arg, args);
                AbstractMap.SimpleEntry<String, String> e = CurlOption.parseHeader(headerArg);
                headers.add(e);
                continue;
            }
            if (arg.equals("-x")) {
                String proxyArg = CurlOption.removeArgFor(arg, args);
                proxy = CurlOption.parseProxy(proxyArg);
                continue;
            }
            if (url != null) {
                throw new IllegalArgumentException("'" + cmdLine + "' was not a valid curl command");
            }
            url = CurlOption.parseUrl(arg);
        }
        if (url == null) {
            throw new IllegalArgumentException("'" + cmdLine + "' was not a valid curl command");
        }
        return new CurlOption(proxy, method, url, headers);
    }

    private static URI parseUrl(String arg) {
        try {
            return new URI(arg);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("'" + arg + "' was not a valid url", e);
        }
    }

    private static Proxy parseProxy(String arg) {
        Proxy.Type type;
        URI url;
        try {
            url = new URI(arg);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("'" + arg + "' was not a valid proxy address", e);
        }
        String protocol = url.getScheme();
        if (protocol == null) {
            throw new IllegalArgumentException("'" + arg + "' did not have a valid proxy protocol");
        }
        if (protocol.equalsIgnoreCase("http") || protocol.equalsIgnoreCase("https")) {
            type = Proxy.Type.HTTP;
        } else if (protocol.equalsIgnoreCase("socks")) {
            type = Proxy.Type.SOCKS;
        } else {
            throw new IllegalArgumentException("'" + arg + "' did not have a valid proxy protocol");
        }
        String host = url.getHost();
        if (host == null) {
            throw new IllegalArgumentException("'" + arg + "' did not have a valid proxy host");
        }
        int port = url.getPort();
        if (port == -1) {
            throw new IllegalArgumentException("'" + arg + "' did not have a valid proxy port");
        }
        return new Proxy(type, new InetSocketAddress(host, port));
    }

    private static String removeArgFor(String arg, List<String> args) {
        if (!args.isEmpty()) {
            return args.remove(0);
        }
        throw new IllegalArgumentException("Missing argument for " + arg);
    }

    private static AbstractMap.SimpleEntry<String, String> parseHeader(String headerArg) {
        String[] parts = headerArg.split(":", 2);
        if (parts.length != 2) {
            throw new IllegalArgumentException("'" + headerArg + "' was not a valid header");
        }
        return new AbstractMap.SimpleEntry<String, String>(parts[0].trim(), parts[1].trim());
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public List<Map.Entry<String, String>> getHeaders() {
        return this.headers;
    }

    public URI getUri() {
        return this.uri;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public static enum HttpMethod {
        GET,
        HEAD,
        POST,
        PUT,
        PATCH,
        DELETE,
        OPTIONS,
        TRACE;


        static HttpMethod parse(String argument) {
            for (HttpMethod value : HttpMethod.values()) {
                if (!value.name().equals(argument)) continue;
                return value;
            }
            throw new IllegalArgumentException(argument + " was not a http method");
        }
    }
}

