/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.plugin.Jackson;
import io.cucumber.messages.MessageToNdjsonWriter;
import io.cucumber.messages.types.Envelope;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.EventPublisher;
import java.io.IOException;
import java.io.OutputStream;

public final class MessageFormatter
implements ConcurrentEventListener {
    private final MessageToNdjsonWriter writer;

    public MessageFormatter(OutputStream outputStream) {
        this.writer = new MessageToNdjsonWriter(outputStream, Jackson.OBJECT_MAPPER::writeValue);
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(Envelope.class, this::write);
    }

    private void write(Envelope event) {
        try {
            this.writer.write(event);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (event.getTestRunFinished().isPresent()) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

