/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

class RegexpUtils {
    private static final boolean[] CHAR_TO_ESCAPE = new boolean[126];

    RegexpUtils() {
    }

    public static String escapeRegex(String text) {
        int length = text.length();
        StringBuilder sb = null;
        int blockStart = 0;
        int maxChar = CHAR_TO_ESCAPE.length;
        for (int i = 0; i < length; ++i) {
            char currentChar = text.charAt(i);
            if (currentChar >= maxChar || !CHAR_TO_ESCAPE[currentChar]) continue;
            if (sb == null) {
                sb = new StringBuilder(length * 2);
            }
            if (blockStart < i) {
                sb.append(text, blockStart, i);
            }
            sb.append('\\');
            sb.append(currentChar);
            blockStart = i + 1;
        }
        if (sb != null) {
            if (blockStart < length) {
                sb.append(text, blockStart, length);
            }
            return sb.toString();
        }
        return text;
    }

    static {
        RegexpUtils.CHAR_TO_ESCAPE[94] = true;
        RegexpUtils.CHAR_TO_ESCAPE[36] = true;
        RegexpUtils.CHAR_TO_ESCAPE[91] = true;
        RegexpUtils.CHAR_TO_ESCAPE[93] = true;
        RegexpUtils.CHAR_TO_ESCAPE[40] = true;
        RegexpUtils.CHAR_TO_ESCAPE[41] = true;
        RegexpUtils.CHAR_TO_ESCAPE[123] = true;
        RegexpUtils.CHAR_TO_ESCAPE[125] = true;
        RegexpUtils.CHAR_TO_ESCAPE[46] = true;
        RegexpUtils.CHAR_TO_ESCAPE[124] = true;
        RegexpUtils.CHAR_TO_ESCAPE[63] = true;
        RegexpUtils.CHAR_TO_ESCAPE[42] = true;
        RegexpUtils.CHAR_TO_ESCAPE[43] = true;
        RegexpUtils.CHAR_TO_ESCAPE[92] = true;
    }
}

