/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.Argument;
import io.cucumber.cucumberexpressions.Expression;
import io.cucumber.cucumberexpressions.GroupBuilder;
import io.cucumber.cucumberexpressions.ObjectMapperTransformer;
import io.cucumber.cucumberexpressions.ParameterByTypeTransformer;
import io.cucumber.cucumberexpressions.ParameterType;
import io.cucumber.cucumberexpressions.ParameterTypeRegistry;
import io.cucumber.cucumberexpressions.TreeRegexp;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class RegularExpression
implements Expression {
    private final Pattern expressionRegexp;
    private final ParameterTypeRegistry parameterTypeRegistry;
    private final TreeRegexp treeRegexp;

    public RegularExpression(Pattern expressionRegexp, ParameterTypeRegistry parameterTypeRegistry) {
        this.expressionRegexp = expressionRegexp;
        this.parameterTypeRegistry = parameterTypeRegistry;
        this.treeRegexp = new TreeRegexp(expressionRegexp);
    }

    @Override
    public List<Argument<?>> match(String text, Type ... typeHints) {
        ParameterByTypeTransformer defaultTransformer = this.parameterTypeRegistry.getDefaultParameterTransformer();
        ArrayList parameterTypes = new ArrayList();
        int typeHintIndex = 0;
        for (GroupBuilder groupBuilder : this.treeRegexp.getGroupBuilder().getChildren()) {
            String parameterTypeRegexp = groupBuilder.getSource();
            Class<String> typeHint = typeHintIndex < typeHints.length ? typeHints[typeHintIndex++] : String.class;
            ParameterType<Object> parameterType = this.parameterTypeRegistry.lookupByRegexp(parameterTypeRegexp, this.expressionRegexp, text);
            if (parameterType == null) {
                parameterType = ParameterType.createAnonymousParameterType(parameterTypeRegexp);
            }
            if (parameterType.isAnonymous()) {
                ObjectMapperTransformer transformer = new ObjectMapperTransformer(defaultTransformer, (Type)((Object)typeHint));
                parameterType = parameterType.deAnonymize((Type)((Object)typeHint), transformer);
            }
            parameterTypes.add(parameterType);
        }
        return Argument.build(this.treeRegexp, parameterTypes, text);
    }

    @Override
    public Pattern getRegexp() {
        return this.expressionRegexp;
    }

    @Override
    public String getSource() {
        return this.expressionRegexp.pattern();
    }
}

