package io.cucumber.java8;

import io.cucumber.java8.StepdefBody.A0;
import io.cucumber.java8.StepdefBody.A1;
import io.cucumber.java8.StepdefBody.A2;
import io.cucumber.java8.StepdefBody.A3;
import io.cucumber.java8.StepdefBody.A4;
import io.cucumber.java8.StepdefBody.A5;
import io.cucumber.java8.StepdefBody.A6;
import io.cucumber.java8.StepdefBody.A7;
import io.cucumber.java8.StepdefBody.A8;
import io.cucumber.java8.StepdefBody.A9;

import cucumber.runtime.java.LambdaGlueRegistry;
import cucumber.runtime.java8.Java8StepDefinition;
import io.cucumber.java8.LambdaGlue;

import org.apiguardian.api.API;

/**
 * Gallegan
 * <p>
 * To execute steps in a feature file the steps must be
 * connected to executable code. This can be done by
 * implementing this interface.
 * <p>
 * The parameters extracted from the step by the expression
 * along with the data table or doc string argument are provided as
 * arguments to the lambda expression.
 * <p>
 * The types of the parameters are determined by the cucumber or
 * regular expression.
 * <p>
 * The type of the data table or doc string argument is determined
 * by the argument name value. When none is provided cucumber will
 * attempt to transform the data table or doc string to the the
 * type of last argument.
 */
@API(status = API.Status.STABLE)
public interface Gl extends LambdaGlue {

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Cando(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void Cando(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Cando(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Cando(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Cando(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Cando(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Cando(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Cando(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Cando(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Cando(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Cando(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Cando(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Cando(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Cando(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Cando(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Cando(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Cando(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Cando(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Cando(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Cando(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Dada(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void Dada(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Dada(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Dada(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Dada(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Dada(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Dada(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Dada(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Dada(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Dada(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Dada(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Dada(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Dada(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Dada(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Dada(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Dada(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Dada(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Dada(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Dada(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Dada(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Dadas(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void Dadas(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Dadas(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Dadas(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Dadas(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Dadas(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Dadas(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Dadas(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Dadas(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Dadas(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Dadas(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Dadas(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Dadas(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Dadas(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Dadas(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Dadas(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Dadas(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Dadas(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Dadas(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Dadas(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Dado(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void Dado(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Dado(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Dado(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Dado(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Dado(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Dado(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Dado(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Dado(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Dado(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Dado(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Dado(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Dado(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Dado(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Dado(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Dado(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Dado(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Dado(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Dado(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Dado(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Dados(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void Dados(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Dados(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Dados(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Dados(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Dados(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Dados(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Dados(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Dados(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Dados(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Dados(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Dados(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Dados(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Dados(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Dados(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Dados(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Dados(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Dados(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Dados(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Dados(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void E(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void E(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void E(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void E(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void E(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void E(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void E(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void E(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void E(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void E(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void E(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void E(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void E(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void E(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void E(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void E(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void E(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void E(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void E(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void E(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Entón(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void Entón(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Entón(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Entón(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Entón(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Entón(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Entón(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Entón(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Entón(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Entón(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Entón(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Entón(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Entón(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Entón(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Entón(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Entón(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Entón(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Entón(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Entón(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Entón(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Logo(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void Logo(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Logo(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Logo(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Logo(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Logo(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Logo(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Logo(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Logo(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Logo(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Logo(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Logo(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Logo(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Logo(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Logo(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Logo(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Logo(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Logo(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Logo(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Logo(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Mais(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void Mais(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Mais(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Mais(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Mais(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Mais(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Mais(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Mais(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Mais(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Mais(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Mais(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Mais(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Mais(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Mais(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Mais(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Mais(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Mais(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Mais(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Mais(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Mais(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Pero(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void Pero(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Pero(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Pero(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Pero(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Pero(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Pero(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Pero(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Pero(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Pero(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Pero(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Pero(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Pero(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Pero(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Pero(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Pero(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Pero(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Pero(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Pero(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Pero(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

}
