/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.java8;

import io.cucumber.core.backend.HookDefinition;
import io.cucumber.core.backend.TestCaseState;
import io.cucumber.java8.AbstractGlueDefinition;
import io.cucumber.java8.HookBody;
import io.cucumber.java8.HookNoArgsBody;
import io.cucumber.java8.Scenario;
import java.util.Objects;
import java.util.Optional;

final class Java8HookDefinition
extends AbstractGlueDefinition
implements HookDefinition {
    private final String tagExpression;
    private final int order;
    private final HookDefinition.HookType hookType;

    Java8HookDefinition(HookDefinition.HookType hookType, String tagExpression, int order, HookBody hookBody) {
        this(hookType, tagExpression, order, (Object)hookBody);
    }

    private Java8HookDefinition(HookDefinition.HookType hookType, String tagExpression, int order, Object body) {
        super(body, new Exception().getStackTrace()[3]);
        this.order = order;
        this.tagExpression = Objects.requireNonNull(tagExpression, "tag-expression may not be null");
        this.hookType = Objects.requireNonNull(hookType);
    }

    Java8HookDefinition(HookDefinition.HookType hookType, String tagExpression, int order, HookNoArgsBody hookNoArgsBody) {
        this(hookType, tagExpression, order, (Object)hookNoArgsBody);
    }

    public void execute(TestCaseState state) {
        Object[] args = this.getParameterCount() == 0 ? new Object[]{} : new Object[]{new Scenario(state)};
        this.invokeMethod(args);
    }

    public String getTagExpression() {
        return this.tagExpression;
    }

    public int getOrder() {
        return this.order;
    }

    public Optional<HookDefinition.HookType> getHookType() {
        return Optional.of(this.hookType);
    }
}

