/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.docstring;

import io.cucumber.docstring.ConversionRequired;
import io.cucumber.docstring.DocStringFormatter;
import java.lang.reflect.Type;
import java.util.Objects;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class DocString {
    private final String content;
    private final String contentType;
    private final DocStringConverter converter;

    private DocString(String content, String contentType, DocStringConverter converter) {
        this.content = Objects.requireNonNull(content);
        this.contentType = contentType;
        this.converter = Objects.requireNonNull(converter);
    }

    public static DocString create(String content) {
        return DocString.create(content, null);
    }

    public static DocString create(String content, String contentType) {
        return DocString.create(content, contentType, new ConversionRequired());
    }

    public static DocString create(String content, String contentType, DocStringConverter converter) {
        return new DocString(content, contentType, converter);
    }

    public Object convert(Type type) {
        return this.converter.convert(this, type);
    }

    public String getContent() {
        return this.content;
    }

    public String getContentType() {
        return this.contentType;
    }

    public int hashCode() {
        return Objects.hash(this.content, this.contentType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocString docString = (DocString)o;
        return this.content.equals(docString.content) && Objects.equals(this.contentType, docString.contentType);
    }

    public String toString() {
        return DocStringFormatter.builder().build().format(this);
    }

    public static interface DocStringConverter {
        public <T> T convert(DocString var1, Type var2);
    }
}

