/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junitxmlformatter;

import io.cucumber.junitxmlformatter.GherkingAstNodes;
import io.cucumber.junitxmlformatter.Query;
import io.cucumber.messages.types.Duration;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.PickleStep;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.TestCaseStarted;
import io.cucumber.messages.types.TestStep;
import io.cucumber.messages.types.TestStepFinished;
import io.cucumber.messages.types.TestStepResult;
import io.cucumber.messages.types.TestStepResultStatus;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

class XmlReportData {
    private final Query query = new Query();
    private static final long MILLIS_PER_SECOND = TimeUnit.SECONDS.toMillis(1L);
    private static final Duration ZERO_DURATION = new Duration(Long.valueOf(0L), Long.valueOf(0L));
    private static final TestStepResult SCENARIO_WITH_NO_STEPS = new TestStepResult(ZERO_DURATION, null, TestStepResultStatus.PASSED, null);

    XmlReportData() {
    }

    void collect(Envelope envelope) {
        this.query.update(envelope);
    }

    double getSuiteDurationInSeconds() {
        return (double)this.query.findTestRunDuration().orElse(java.time.Duration.ZERO).toMillis() / (double)MILLIS_PER_SECOND;
    }

    double getDurationInSeconds(TestCaseStarted testCaseStarted) {
        return (double)this.query.findTestCaseDurationBy(testCaseStarted).orElse(java.time.Duration.ZERO).toMillis() / (double)MILLIS_PER_SECOND;
    }

    Map<TestStepResultStatus, Long> getTestCaseStatusCounts() {
        return this.query.findAllTestCaseStarted().stream().map(this.query::findMostSevereTestStepResultStatusBy).filter(Optional::isPresent).map(Optional::get).map(TestStepResult::getStatus).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
    }

    int getTestCaseCount() {
        return this.query.findAllTestCaseStarted().size();
    }

    String getPickleName(TestCaseStarted testCaseStarted) {
        Pickle pickle = this.query.findPickleBy(testCaseStarted).orElseThrow(() -> new IllegalStateException("No pickle for " + testCaseStarted.getId()));
        return this.query.findGherkinAstNodesBy(pickle).map(XmlReportData::getPickleName).orElse(pickle.getName());
    }

    private static String getPickleName(GherkingAstNodes elements) {
        ArrayList<String> pieces = new ArrayList<String>();
        elements.rule().map(Rule::getName).ifPresent(pieces::add);
        pieces.add(elements.scenario().getName());
        elements.examples().map(Examples::getName).ifPresent(pieces::add);
        String examplesPrefix = elements.examplesIndex().map(examplesIndex -> examplesIndex + 1).map(examplesIndex -> examplesIndex + ".").orElse("");
        elements.exampleIndex().map(exampleIndex -> exampleIndex + 1).map(exampleSuffix -> "Example #" + examplesPrefix + exampleSuffix).ifPresent(pieces::add);
        return pieces.stream().filter(s -> !s.isEmpty()).collect(Collectors.joining(" - "));
    }

    public String getFeatureName(TestCaseStarted testCaseStarted) {
        return this.query.findGherkinAstNodesBy(testCaseStarted).map(GherkingAstNodes::feature).map(Feature::getName).orElseThrow(() -> new IllegalStateException("No feature for " + testCaseStarted));
    }

    List<Map.Entry<String, String>> getStepsAndResult(TestCaseStarted testCaseStarted) {
        return this.query.findTestStepAndTestStepFinishedBy(testCaseStarted).stream().filter(entry -> ((TestStep)entry.getKey()).getPickleStepId().isPresent()).map(testStep -> {
            String key = this.renderTestStepText((TestStep)testStep.getKey());
            String value = this.renderTestStepResult((TestStepFinished)testStep.getValue());
            return new AbstractMap.SimpleEntry<String, String>(key, value);
        }).collect(Collectors.toList());
    }

    private String renderTestStepResult(TestStepFinished testStepFinished) {
        return testStepFinished.getTestStepResult().getStatus().toString().toLowerCase(Locale.ROOT);
    }

    private String renderTestStepText(TestStep testStep) {
        Optional<PickleStep> pickleStep = this.query.findPickleStepBy(testStep);
        String stepKeyWord = pickleStep.flatMap(this.query::findStepBy).map(Step::getKeyword).orElse("");
        String stepText = pickleStep.map(PickleStep::getText).orElse("");
        return stepKeyWord + stepText;
    }

    List<TestCaseStarted> getAllTestCaseStarted() {
        return this.query.findAllTestCaseStarted();
    }

    TestStepResult getTestCaseStatus(TestCaseStarted testCaseStarted) {
        return this.query.findMostSevereTestStepResultStatusBy(testCaseStarted).orElse(SCENARIO_WITH_NO_STEPS);
    }
}

