
package io.cucumber.messages.types;

import java.util.ArrayList;
import java.util.List;

public class DataTable {

    /**
     * *
     *  Points to a line and a column in a text file
     * (Required)
     * 
     */
    private Location location;
    /**
     * 
     * (Required)
     * 
     */
    private List<TableRow> rows = new ArrayList<TableRow>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataTable() {
    }

    /**
     * 
     * @param location
     * @param rows
     */
    public DataTable(Location location, List<TableRow> rows) {
        super();
        this.location = location;
        this.rows = rows;
    }

    /**
     * *
     *  Points to a line and a column in a text file
     * (Required)
     * 
     */
    public Location getLocation() {
        return location;
    }

    /**
     * *
     *  Points to a line and a column in a text file
     * (Required)
     * 
     */
    public void setLocation(Location location) {
        this.location = location;
    }

    /**
     * 
     * (Required)
     * 
     */
    public List<TableRow> getRows() {
        return rows;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setRows(List<TableRow> rows) {
        this.rows = rows;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataTable.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("location");
        sb.append('=');
        sb.append(((this.location == null)?"<null>":this.location));
        sb.append(',');
        sb.append("rows");
        sb.append('=');
        sb.append(((this.rows == null)?"<null>":this.rows));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.rows == null)? 0 :this.rows.hashCode()));
        result = ((result* 31)+((this.location == null)? 0 :this.location.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataTable) == false) {
            return false;
        }
        DataTable rhs = ((DataTable) other);
        return (((this.rows == rhs.rows)||((this.rows!= null)&&this.rows.equals(rhs.rows)))&&((this.location == rhs.location)||((this.location!= null)&&this.location.equals(rhs.location))));
    }

}
