
package io.cucumber.messages.types;


public class TestCaseStarted {

    /**
     * *
     *  The first attempt should have value 0, and for each retry the value
     *  should increase by 1.
     * (Required)
     * 
     */
    private Long attempt;
    /**
     * *
     *  Because a `TestCase` can be run multiple times (in case of a retry),
     *  we use this field to group messages relating to the same attempt.
     * (Required)
     * 
     */
    private String id;
    /**
     * 
     * (Required)
     * 
     */
    private String testCaseId;
    /**
     * 
     * (Required)
     * 
     */
    private Timestamp timestamp;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TestCaseStarted() {
    }

    /**
     * 
     * @param id
     * @param attempt
     * @param testCaseId
     * @param timestamp
     */
    public TestCaseStarted(Long attempt, String id, String testCaseId, Timestamp timestamp) {
        super();
        this.attempt = attempt;
        this.id = id;
        this.testCaseId = testCaseId;
        this.timestamp = timestamp;
    }

    /**
     * *
     *  The first attempt should have value 0, and for each retry the value
     *  should increase by 1.
     * (Required)
     * 
     */
    public Long getAttempt() {
        return attempt;
    }

    /**
     * *
     *  The first attempt should have value 0, and for each retry the value
     *  should increase by 1.
     * (Required)
     * 
     */
    public void setAttempt(Long attempt) {
        this.attempt = attempt;
    }

    /**
     * *
     *  Because a `TestCase` can be run multiple times (in case of a retry),
     *  we use this field to group messages relating to the same attempt.
     * (Required)
     * 
     */
    public String getId() {
        return id;
    }

    /**
     * *
     *  Because a `TestCase` can be run multiple times (in case of a retry),
     *  we use this field to group messages relating to the same attempt.
     * (Required)
     * 
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getTestCaseId() {
        return testCaseId;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setTestCaseId(String testCaseId) {
        this.testCaseId = testCaseId;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Timestamp getTimestamp() {
        return timestamp;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TestCaseStarted.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attempt");
        sb.append('=');
        sb.append(((this.attempt == null)?"<null>":this.attempt));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("testCaseId");
        sb.append('=');
        sb.append(((this.testCaseId == null)?"<null>":this.testCaseId));
        sb.append(',');
        sb.append("timestamp");
        sb.append('=');
        sb.append(((this.timestamp == null)?"<null>":this.timestamp));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.attempt == null)? 0 :this.attempt.hashCode()));
        result = ((result* 31)+((this.testCaseId == null)? 0 :this.testCaseId.hashCode()));
        result = ((result* 31)+((this.timestamp == null)? 0 :this.timestamp.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TestCaseStarted) == false) {
            return false;
        }
        TestCaseStarted rhs = ((TestCaseStarted) other);
        return (((((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id)))&&((this.attempt == rhs.attempt)||((this.attempt!= null)&&this.attempt.equals(rhs.attempt))))&&((this.testCaseId == rhs.testCaseId)||((this.testCaseId!= null)&&this.testCaseId.equals(rhs.testCaseId))))&&((this.timestamp == rhs.timestamp)||((this.timestamp!= null)&&this.timestamp.equals(rhs.timestamp))));
    }

}
