/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import java.util.Objects;
import java.util.Optional;

public final class Exception {
    private final String type;
    private final String message;

    public Exception(String type, String message) {
        this.type = Objects.requireNonNull(type, "Exception.type cannot be null");
        this.message = message;
    }

    public String getType() {
        return this.type;
    }

    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Exception that = (Exception)o;
        return this.type.equals(that.type) && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.message);
    }

    public String toString() {
        return "Exception{type=" + this.type + ", message=" + this.message + '}';
    }
}

