/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.query;

import io.cucumber.messages.Convertor;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.PickleStep;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.TableRow;
import io.cucumber.messages.types.TestCase;
import io.cucumber.messages.types.TestCaseFinished;
import io.cucumber.messages.types.TestCaseStarted;
import io.cucumber.messages.types.TestRunFinished;
import io.cucumber.messages.types.TestRunStarted;
import io.cucumber.messages.types.TestStep;
import io.cucumber.messages.types.TestStepFinished;
import io.cucumber.messages.types.TestStepResult;
import io.cucumber.messages.types.TestStepResultStatus;
import io.cucumber.messages.types.Timestamp;
import io.cucumber.query.GherkinDocumentElements;
import io.cucumber.query.NamingStrategy;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class Query {
    private final Comparator<TestStepResult> testStepResultComparator = Comparator.nullsFirst(Comparator.comparing(o -> o.getStatus().ordinal()));
    private final Deque<TestCaseStarted> testCaseStarted = new ConcurrentLinkedDeque<TestCaseStarted>();
    private final Map<String, TestCaseFinished> testCaseFinishedByTestCaseStartedId = new ConcurrentHashMap<String, TestCaseFinished>();
    private final Map<String, List<TestStepFinished>> testStepsFinishedByTestCaseStartedId = new ConcurrentHashMap<String, List<TestStepFinished>>();
    private final Map<String, Pickle> pickleById = new ConcurrentHashMap<String, Pickle>();
    private final Map<String, TestCase> testCaseById = new ConcurrentHashMap<String, TestCase>();
    private final Map<String, Step> stepById = new ConcurrentHashMap<String, Step>();
    private final Map<String, TestStep> testStepById = new ConcurrentHashMap<String, TestStep>();
    private final Map<String, PickleStep> pickleStepById = new ConcurrentHashMap<String, PickleStep>();
    private final Map<String, GherkinDocumentElements> gherkinAstNodesById = new ConcurrentHashMap<String, GherkinDocumentElements>();
    private TestRunStarted testRunStarted;
    private TestRunFinished testRunFinished;

    public Map<TestStepResultStatus, Long> countMostSevereTestStepResultStatus() {
        return this.findAllTestCaseStarted().stream().map(this::findMostSevereTestStepResulBy).filter(Optional::isPresent).map(Optional::get).map(TestStepResult::getStatus).collect(Collectors.groupingBy(Function.identity(), LinkedHashMap::new, Collectors.counting()));
    }

    public int countTestCasesStarted() {
        return this.testCaseStarted.size();
    }

    public List<Pickle> findAllPickles() {
        return this.pickleById.values().stream().sorted(Comparator.comparing(Pickle::getId)).collect(Collectors.toList());
    }

    public List<PickleStep> findAllPickleSteps() {
        return this.pickleStepById.values().stream().sorted(Comparator.comparing(PickleStep::getId)).collect(Collectors.toList());
    }

    public List<TestCaseStarted> findAllTestCaseStarted() {
        return new ArrayList<TestCaseStarted>(this.testCaseStarted);
    }

    public Map<Optional<Feature>, List<TestCaseStarted>> findAllTestCaseStartedGroupedByFeature() {
        return this.findAllTestCaseStarted().stream().map(testCaseStarted1 -> {
            Optional<GherkinDocumentElements> astNodes = this.findGherkinAstNodesBy((TestCaseStarted)testCaseStarted1);
            return new AbstractMap.SimpleEntry<Optional<GherkinDocumentElements>, TestCaseStarted>(astNodes, (TestCaseStarted)testCaseStarted1);
        }).sorted(Comparator.nullsFirst(Comparator.comparing(entry1 -> ((Optional)entry1.getKey()).flatMap(nodes -> nodes.document().getUri()).orElse(null)))).map(entry -> {
            Optional feature = ((Optional)entry.getKey()).flatMap(GherkinDocumentElements::feature);
            TestCaseStarted testcaseStarted = (TestCaseStarted)entry.getValue();
            return new AbstractMap.SimpleEntry(feature, testcaseStarted);
        }).collect(Collectors.groupingBy(AbstractMap.SimpleEntry::getKey, LinkedHashMap::new, Collectors.collectingAndThen(Collectors.toList(), entries -> entries.stream().map(AbstractMap.SimpleEntry::getValue).collect(Collectors.toList()))));
    }

    public List<TestStep> findAllTestSteps() {
        return this.testStepById.values().stream().sorted(Comparator.comparing(TestStep::getId)).collect(Collectors.toList());
    }

    public Optional<Feature> findFeatureBy(TestCaseStarted testCaseStarted) {
        return this.findGherkinAstNodesBy(testCaseStarted).flatMap(GherkinDocumentElements::feature);
    }

    public Optional<TestStepResult> findMostSevereTestStepResulBy(TestCaseStarted testCaseStarted) {
        Objects.requireNonNull(testCaseStarted);
        return this.findTestStepsFinishedBy(testCaseStarted).stream().map(TestStepFinished::getTestStepResult).max(this.testStepResultComparator);
    }

    public String findNameOf(Pickle pickle, NamingStrategy namingStrategy) {
        Objects.requireNonNull(pickle);
        Objects.requireNonNull(namingStrategy);
        return this.findGherkinAstNodesBy(pickle).map(gherkinDocumentElements -> namingStrategy.name((GherkinDocumentElements)gherkinDocumentElements, pickle)).orElse(pickle.getName());
    }

    public Optional<Pickle> findPickleBy(TestCaseStarted testCaseStarted) {
        Objects.requireNonNull(testCaseStarted);
        return this.findTestCaseBy(testCaseStarted).map(TestCase::getPickleId).map(this.pickleById::get);
    }

    public Optional<PickleStep> findPickleStepBy(TestStep testStep) {
        Objects.requireNonNull(this.testCaseStarted);
        return testStep.getPickleStepId().map(this.pickleStepById::get);
    }

    public Optional<Step> findStepBy(PickleStep pickleStep) {
        Objects.requireNonNull(pickleStep);
        String stepId = (String)pickleStep.getAstNodeIds().get(0);
        return Optional.ofNullable(this.stepById.get(stepId));
    }

    public Optional<TestCase> findTestCaseBy(TestCaseStarted testCaseStarted) {
        Objects.requireNonNull(testCaseStarted);
        return Optional.ofNullable(this.testCaseById.get(testCaseStarted.getTestCaseId()));
    }

    public Optional<Duration> findTestCaseDurationBy(TestCaseStarted testCaseStarted) {
        Objects.requireNonNull(testCaseStarted);
        Timestamp started = testCaseStarted.getTimestamp();
        return this.findTestCaseFinishedBy(testCaseStarted).map(TestCaseFinished::getTimestamp).map(finished -> Duration.between(Convertor.toInstant((Timestamp)started), Convertor.toInstant((Timestamp)finished)));
    }

    public Optional<TestCaseFinished> findTestCaseFinishedBy(TestCaseStarted testCaseStarted) {
        Objects.requireNonNull(testCaseStarted);
        return Optional.ofNullable(this.testCaseFinishedByTestCaseStartedId.get(testCaseStarted.getId()));
    }

    public Optional<Duration> findTestRunDuration() {
        if (this.testRunStarted == null || this.testRunFinished == null) {
            return Optional.empty();
        }
        Duration between = Duration.between(Convertor.toInstant((Timestamp)this.testRunStarted.getTimestamp()), Convertor.toInstant((Timestamp)this.testRunFinished.getTimestamp()));
        return Optional.of(between);
    }

    public Optional<TestRunFinished> findTestRunFinished() {
        return Optional.ofNullable(this.testRunFinished);
    }

    public Optional<TestRunStarted> findTestRunStarted() {
        return Optional.ofNullable(this.testRunStarted);
    }

    public Optional<TestStep> findTestStepBy(TestStepFinished testStepFinished) {
        Objects.requireNonNull(testStepFinished);
        return Optional.ofNullable(this.testStepById.get(testStepFinished.getTestStepId()));
    }

    public List<TestStepFinished> findTestStepsFinishedBy(TestCaseStarted testCaseStarted) {
        Objects.requireNonNull(testCaseStarted);
        List testStepsFinished = this.testStepsFinishedByTestCaseStartedId.getOrDefault(testCaseStarted.getId(), Collections.emptyList());
        return new ArrayList<TestStepFinished>(testStepsFinished);
    }

    public List<Map.Entry<TestStepFinished, TestStep>> findTestStepFinishedAndTestStepBy(TestCaseStarted testCaseStarted) {
        return this.findTestStepsFinishedBy(testCaseStarted).stream().map(testStepFinished -> this.findTestStepBy((TestStepFinished)testStepFinished).map(testStep -> new AbstractMap.SimpleEntry<TestStepFinished, TestStep>((TestStepFinished)testStepFinished, (TestStep)testStep))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public void update(Envelope envelope) {
        envelope.getTestRunStarted().ifPresent(this::updateTestRunStarted);
        envelope.getTestRunFinished().ifPresent(this::updateTestRunFinished);
        envelope.getTestCaseStarted().ifPresent(this::updateTestCaseStarted);
        envelope.getTestCaseFinished().ifPresent(this::updateTestCaseFinished);
        envelope.getTestStepFinished().ifPresent(this::updateTestStepFinished);
        envelope.getGherkinDocument().ifPresent(this::updateGherkinDocument);
        envelope.getPickle().ifPresent(this::updatePickle);
        envelope.getTestCase().ifPresent(this::updateTestCase);
    }

    private Optional<GherkinDocumentElements> findGherkinAstNodesBy(Pickle pickle) {
        Objects.requireNonNull(pickle);
        List astNodeIds = pickle.getAstNodeIds();
        String pickleAstNodeId = (String)astNodeIds.get(astNodeIds.size() - 1);
        return Optional.ofNullable(this.gherkinAstNodesById.get(pickleAstNodeId));
    }

    private Optional<GherkinDocumentElements> findGherkinAstNodesBy(TestCaseStarted testCaseStarted) {
        return this.findPickleBy(testCaseStarted).flatMap(this::findGherkinAstNodesBy);
    }

    private void updateTestCaseStarted(TestCaseStarted testCaseStarted) {
        this.testCaseStarted.add(testCaseStarted);
    }

    private void updateTestCase(TestCase event) {
        this.testCaseById.put(event.getId(), event);
        event.getTestSteps().forEach(testStep -> this.testStepById.put(testStep.getId(), (TestStep)testStep));
    }

    private void updatePickle(Pickle event) {
        this.pickleById.put(event.getId(), event);
        event.getSteps().forEach(pickleStep -> this.pickleStepById.put(pickleStep.getId(), (PickleStep)pickleStep));
    }

    private void updateGherkinDocument(GherkinDocument document) {
        document.getFeature().ifPresent(feature -> this.updateFeature(document, (Feature)feature));
    }

    private void updateFeature(GherkinDocument document, Feature feature) {
        feature.getChildren().forEach(featureChild -> {
            featureChild.getBackground().ifPresent(background -> this.updateSteps(background.getSteps()));
            featureChild.getScenario().ifPresent(scenario -> this.updateScenario(document, feature, null, (Scenario)scenario));
            featureChild.getRule().ifPresent(rule -> rule.getChildren().forEach(ruleChild -> {
                ruleChild.getBackground().ifPresent(background -> this.updateSteps(background.getSteps()));
                ruleChild.getScenario().ifPresent(scenario -> this.updateScenario(document, feature, (Rule)rule, (Scenario)scenario));
            }));
        });
    }

    private void updateSteps(List<Step> steps) {
        steps.forEach(step -> this.stepById.put(step.getId(), (Step)step));
    }

    private void updateTestStepFinished(TestStepFinished event) {
        this.testStepsFinishedByTestCaseStartedId.compute(event.getTestCaseStartedId(), this.updateList(event));
    }

    private void updateTestCaseFinished(TestCaseFinished event) {
        this.testCaseFinishedByTestCaseStartedId.put(event.getTestCaseStartedId(), event);
    }

    private void updateTestRunFinished(TestRunFinished event) {
        this.testRunFinished = event;
    }

    private void updateTestRunStarted(TestRunStarted event) {
        this.testRunStarted = event;
    }

    private void updateScenario(GherkinDocument document, Feature feature, Rule rule, Scenario scenario) {
        this.gherkinAstNodesById.put(scenario.getId(), new GherkinDocumentElements(document, feature, rule, scenario));
        this.updateSteps(scenario.getSteps());
        List examples = scenario.getExamples();
        for (int examplesIndex = 0; examplesIndex < examples.size(); ++examplesIndex) {
            Examples currentExamples = (Examples)examples.get(examplesIndex);
            List tableRows = currentExamples.getTableBody();
            for (int exampleIndex = 0; exampleIndex < tableRows.size(); ++exampleIndex) {
                TableRow currentExample = (TableRow)tableRows.get(exampleIndex);
                this.gherkinAstNodesById.put(currentExample.getId(), new GherkinDocumentElements(document, feature, rule, scenario, examplesIndex, currentExamples, exampleIndex, currentExample));
            }
        }
    }

    private <K, E> BiFunction<K, List<E>, List<E>> updateList(E element) {
        return (key, existing) -> {
            if (existing != null) {
                existing.add(element);
                return existing;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(element);
            return list;
        };
    }
}

