/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.config.Configuration;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.Selectors;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.history.SchemaHistory;
import io.debezium.schema.DataCollectionFilters;
import java.util.function.Predicate;

public class RelationalTableFilters
implements DataCollectionFilters {
    private final Tables.TableFilter eligibleTableFilter;
    private final Tables.TableFilter tableFilter;
    private final Predicate<String> databaseFilter;
    private final String excludeColumns;
    private final Tables.TableFilter schemaSnapshotFilter;

    public RelationalTableFilters(Configuration config, Tables.TableFilter systemTablesFilter, Selectors.TableIdToStringMapper tableIdMapper, boolean useCatalogBeforeSchema) {
        Predicate<TableId> eligibleSchemaPredicate;
        TableId signalDataCollectionTableId;
        Selectors.TableSelectionPredicateBuilder eligibleTables = Selectors.tableSelector().includeDatabases(config.getString(RelationalDatabaseConnectorConfig.DATABASE_INCLUDE_LIST)).excludeDatabases(config.getString(RelationalDatabaseConnectorConfig.DATABASE_EXCLUDE_LIST)).includeSchemas(config.getString(RelationalDatabaseConnectorConfig.SCHEMA_INCLUDE_LIST)).excludeSchemas(config.getString(RelationalDatabaseConnectorConfig.SCHEMA_EXCLUDE_LIST));
        Predicate<TableId> eligibleTablePredicate = eligibleTables.build();
        Predicate<TableId> finalEligibleTablePredicate = config.getBoolean(RelationalDatabaseConnectorConfig.TABLE_IGNORE_BUILTIN) ? eligibleTablePredicate.and(systemTablesFilter::isIncluded) : eligibleTablePredicate;
        this.eligibleTableFilter = finalEligibleTablePredicate::test;
        Predicate<TableId> tablePredicate = eligibleTables.includeTables(config.getString(RelationalDatabaseConnectorConfig.TABLE_INCLUDE_LIST), tableIdMapper).excludeTables(config.getString(RelationalDatabaseConnectorConfig.TABLE_EXCLUDE_LIST), tableIdMapper).build();
        Predicate<TableId> finalTablePredicate = config.getBoolean(RelationalDatabaseConnectorConfig.TABLE_IGNORE_BUILTIN) ? tablePredicate.and(systemTablesFilter::isIncluded) : tablePredicate;
        String signalDataCollection = config.getString(RelationalDatabaseConnectorConfig.SIGNAL_DATA_COLLECTION);
        if (signalDataCollection != null && !finalTablePredicate.test(signalDataCollectionTableId = TableId.parse(signalDataCollection, useCatalogBeforeSchema))) {
            Predicate<TableId> signalDataCollectionPredicate = Selectors.tableSelector().includeTables(tableIdMapper.toString(signalDataCollectionTableId), tableIdMapper).build();
            finalTablePredicate = finalTablePredicate.or(signalDataCollectionPredicate);
        }
        this.tableFilter = finalTablePredicate::test;
        this.databaseFilter = Selectors.databaseSelector().includeDatabases(config.getString(RelationalDatabaseConnectorConfig.DATABASE_INCLUDE_LIST)).excludeDatabases(config.getString(RelationalDatabaseConnectorConfig.DATABASE_EXCLUDE_LIST)).build();
        Predicate<TableId> predicate = config.getBoolean(RelationalDatabaseConnectorConfig.TABLE_IGNORE_BUILTIN) ? systemTablesFilter::isIncluded : (eligibleSchemaPredicate = x -> true);
        this.schemaSnapshotFilter = config.getBoolean(SchemaHistory.STORE_ONLY_CAPTURED_TABLES_DDL) ? eligibleSchemaPredicate.and(this.tableFilter::isIncluded)::test : eligibleSchemaPredicate::test;
        this.excludeColumns = config.getString(RelationalDatabaseConnectorConfig.COLUMN_EXCLUDE_LIST);
    }

    public Tables.TableFilter dataCollectionFilter() {
        return this.tableFilter;
    }

    public Tables.TableFilter eligibleDataCollectionFilter() {
        return this.eligibleTableFilter;
    }

    public Tables.TableFilter eligibleForSchemaDataCollectionFilter() {
        return this.schemaSnapshotFilter;
    }

    public Predicate<String> databaseFilter() {
        return this.databaseFilter;
    }

    public String getExcludeColumns() {
        return this.excludeColumns;
    }
}

