/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.schema;

import io.debezium.common.annotation.Incubating;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.schema.AbstractTopicNamingStrategy;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Collect;
import java.util.Properties;

@Incubating
public class SchemaTopicNamingStrategy
extends AbstractTopicNamingStrategy<DataCollectionId> {
    private final boolean multiPartitionMode;

    public SchemaTopicNamingStrategy(Properties props) {
        super(props);
        this.multiPartitionMode = props.get("multi.partition.mode") == null ? false : Boolean.parseBoolean(props.get("multi.partition.mode").toString());
    }

    public SchemaTopicNamingStrategy(Properties props, boolean multiPartitionMode) {
        super(props);
        this.multiPartitionMode = multiPartitionMode;
    }

    public static SchemaTopicNamingStrategy create(CommonConnectorConfig config) {
        return SchemaTopicNamingStrategy.create(config, false);
    }

    public static SchemaTopicNamingStrategy create(CommonConnectorConfig config, boolean multiPartitionMode) {
        return new SchemaTopicNamingStrategy(config.getConfig().asProperties(), multiPartitionMode);
    }

    @Override
    public String dataChangeTopic(DataCollectionId id) {
        String topicName = this.multiPartitionMode ? this.mkString(Collect.arrayListOf(this.prefix, id.parts()), this.delimiter) : this.mkString(Collect.arrayListOf(this.prefix, id.schemaParts()), this.delimiter);
        return this.topicNames.computeIfAbsent(id, t -> this.sanitizedTopicName(topicName));
    }
}

