/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.kubernetes.api.builder.BaseFluent;
import io.dekorate.deps.kubernetes.api.builder.Nested;
import io.dekorate.deps.kubernetes.api.builder.Predicate;
import io.dekorate.deps.kubernetes.api.model.LabelSelector;
import io.dekorate.deps.kubernetes.api.model.LabelSelectorBuilder;
import io.dekorate.deps.kubernetes.api.model.LabelSelectorFluentImpl;
import io.dekorate.deps.kubernetes.api.model.PersistentVolumeClaimSpec;
import io.dekorate.deps.kubernetes.api.model.PersistentVolumeClaimSpecFluent;
import io.dekorate.deps.kubernetes.api.model.ResourceRequirements;
import io.dekorate.deps.kubernetes.api.model.ResourceRequirementsBuilder;
import io.dekorate.deps.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.dekorate.deps.kubernetes.api.model.TypedLocalObjectReference;
import io.dekorate.deps.kubernetes.api.model.TypedLocalObjectReferenceBuilder;
import io.dekorate.deps.kubernetes.api.model.TypedLocalObjectReferenceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PersistentVolumeClaimSpecFluentImpl<A extends PersistentVolumeClaimSpecFluent<A>>
extends BaseFluent<A>
implements PersistentVolumeClaimSpecFluent<A> {
    private List<String> accessModes = new ArrayList<String>();
    private TypedLocalObjectReferenceBuilder dataSource;
    private ResourceRequirementsBuilder resources;
    private LabelSelectorBuilder selector;
    private String storageClassName;
    private String volumeMode;
    private String volumeName;

    public PersistentVolumeClaimSpecFluentImpl() {
    }

    public PersistentVolumeClaimSpecFluentImpl(PersistentVolumeClaimSpec instance) {
        this.withAccessModes(instance.getAccessModes());
        this.withDataSource(instance.getDataSource());
        this.withResources(instance.getResources());
        this.withSelector(instance.getSelector());
        this.withStorageClassName(instance.getStorageClassName());
        this.withVolumeMode(instance.getVolumeMode());
        this.withVolumeName(instance.getVolumeName());
    }

    @Override
    public A addToAccessModes(int index, String item) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        this.accessModes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAccessModes(int index, String item) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        this.accessModes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAccessModes(String ... items) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        for (String item : items) {
            this.accessModes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAccessModes(Collection<String> items) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        for (String item : items) {
            this.accessModes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAccessModes(String ... items) {
        for (String item : items) {
            if (this.accessModes == null) continue;
            this.accessModes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAccessModes(Collection<String> items) {
        for (String item : items) {
            if (this.accessModes == null) continue;
            this.accessModes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAccessModes() {
        return this.accessModes;
    }

    @Override
    public String getAccessMode(int index) {
        return this.accessModes.get(index);
    }

    @Override
    public String getFirstAccessMode() {
        return this.accessModes.get(0);
    }

    @Override
    public String getLastAccessMode() {
        return this.accessModes.get(this.accessModes.size() - 1);
    }

    @Override
    public String getMatchingAccessMode(Predicate<String> predicate) {
        for (String item : this.accessModes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAccessMode(Predicate<String> predicate) {
        for (String item : this.accessModes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAccessModes(List<String> accessModes) {
        if (this.accessModes != null) {
            this._visitables.get("accessModes").removeAll(this.accessModes);
        }
        if (accessModes != null) {
            this.accessModes = new ArrayList<String>();
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        } else {
            this.accessModes = null;
        }
        return (A)this;
    }

    @Override
    public A withAccessModes(String ... accessModes) {
        if (this.accessModes != null) {
            this.accessModes.clear();
        }
        if (accessModes != null) {
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAccessModes() {
        return this.accessModes != null && !this.accessModes.isEmpty();
    }

    @Override
    public A addNewAccessMode(String arg1) {
        return this.addToAccessModes(new String(arg1));
    }

    @Override
    public A addNewAccessMode(StringBuilder arg1) {
        return this.addToAccessModes(new String(arg1));
    }

    @Override
    public A addNewAccessMode(StringBuffer arg1) {
        return this.addToAccessModes(new String(arg1));
    }

    @Override
    @Deprecated
    public TypedLocalObjectReference getDataSource() {
        return this.dataSource != null ? this.dataSource.build() : null;
    }

    @Override
    public TypedLocalObjectReference buildDataSource() {
        return this.dataSource != null ? this.dataSource.build() : null;
    }

    @Override
    public A withDataSource(TypedLocalObjectReference dataSource) {
        this._visitables.get("dataSource").remove(this.dataSource);
        if (dataSource != null) {
            this.dataSource = new TypedLocalObjectReferenceBuilder(dataSource);
            this._visitables.get("dataSource").add(this.dataSource);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDataSource() {
        return this.dataSource != null;
    }

    @Override
    public A withNewDataSource(String apiGroup, String kind, String name) {
        return this.withDataSource(new TypedLocalObjectReference(apiGroup, kind, name));
    }

    @Override
    public PersistentVolumeClaimSpecFluent.DataSourceNested<A> withNewDataSource() {
        return new DataSourceNestedImpl();
    }

    @Override
    public PersistentVolumeClaimSpecFluent.DataSourceNested<A> withNewDataSourceLike(TypedLocalObjectReference item) {
        return new DataSourceNestedImpl(item);
    }

    @Override
    public PersistentVolumeClaimSpecFluent.DataSourceNested<A> editDataSource() {
        return this.withNewDataSourceLike(this.getDataSource());
    }

    @Override
    public PersistentVolumeClaimSpecFluent.DataSourceNested<A> editOrNewDataSource() {
        return this.withNewDataSourceLike(this.getDataSource() != null ? this.getDataSource() : new TypedLocalObjectReferenceBuilder().build());
    }

    @Override
    public PersistentVolumeClaimSpecFluent.DataSourceNested<A> editOrNewDataSourceLike(TypedLocalObjectReference item) {
        return this.withNewDataSourceLike(this.getDataSource() != null ? this.getDataSource() : item);
    }

    @Override
    @Deprecated
    public ResourceRequirements getResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public A withResources(ResourceRequirements resources) {
        this._visitables.get("resources").remove(this.resources);
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.get("resources").add(this.resources);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    public PersistentVolumeClaimSpecFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public PersistentVolumeClaimSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public PersistentVolumeClaimSpecFluent.ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public PersistentVolumeClaimSpecFluent.ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : new ResourceRequirementsBuilder().build());
    }

    @Override
    public PersistentVolumeClaimSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : item);
    }

    @Override
    @Deprecated
    public LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(LabelSelector selector) {
        this._visitables.get("selector").remove(this.selector);
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public PersistentVolumeClaimSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public PersistentVolumeClaimSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public PersistentVolumeClaimSpecFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public PersistentVolumeClaimSpecFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public PersistentVolumeClaimSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    public String getStorageClassName() {
        return this.storageClassName;
    }

    @Override
    public A withStorageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
        return (A)this;
    }

    @Override
    public Boolean hasStorageClassName() {
        return this.storageClassName != null;
    }

    @Override
    public A withNewStorageClassName(String arg1) {
        return this.withStorageClassName(new String(arg1));
    }

    @Override
    public A withNewStorageClassName(StringBuilder arg1) {
        return this.withStorageClassName(new String(arg1));
    }

    @Override
    public A withNewStorageClassName(StringBuffer arg1) {
        return this.withStorageClassName(new String(arg1));
    }

    @Override
    public String getVolumeMode() {
        return this.volumeMode;
    }

    @Override
    public A withVolumeMode(String volumeMode) {
        this.volumeMode = volumeMode;
        return (A)this;
    }

    @Override
    public Boolean hasVolumeMode() {
        return this.volumeMode != null;
    }

    @Override
    public A withNewVolumeMode(String arg1) {
        return this.withVolumeMode(new String(arg1));
    }

    @Override
    public A withNewVolumeMode(StringBuilder arg1) {
        return this.withVolumeMode(new String(arg1));
    }

    @Override
    public A withNewVolumeMode(StringBuffer arg1) {
        return this.withVolumeMode(new String(arg1));
    }

    @Override
    public String getVolumeName() {
        return this.volumeName;
    }

    @Override
    public A withVolumeName(String volumeName) {
        this.volumeName = volumeName;
        return (A)this;
    }

    @Override
    public Boolean hasVolumeName() {
        return this.volumeName != null;
    }

    @Override
    public A withNewVolumeName(String arg1) {
        return this.withVolumeName(new String(arg1));
    }

    @Override
    public A withNewVolumeName(StringBuilder arg1) {
        return this.withVolumeName(new String(arg1));
    }

    @Override
    public A withNewVolumeName(StringBuffer arg1) {
        return this.withVolumeName(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistentVolumeClaimSpecFluentImpl that = (PersistentVolumeClaimSpecFluentImpl)o;
        if (this.accessModes != null ? !this.accessModes.equals(that.accessModes) : that.accessModes != null) {
            return false;
        }
        if (this.dataSource != null ? !this.dataSource.equals(that.dataSource) : that.dataSource != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.storageClassName != null ? !this.storageClassName.equals(that.storageClassName) : that.storageClassName != null) {
            return false;
        }
        if (this.volumeMode != null ? !this.volumeMode.equals(that.volumeMode) : that.volumeMode != null) {
            return false;
        }
        return !(this.volumeName != null ? !this.volumeName.equals(that.volumeName) : that.volumeName != null);
    }

    public class SelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<PersistentVolumeClaimSpecFluent.SelectorNested<N>>
    implements PersistentVolumeClaimSpecFluent.SelectorNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;

        SelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeClaimSpecFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }

    public class ResourcesNestedImpl<N>
    extends ResourceRequirementsFluentImpl<PersistentVolumeClaimSpecFluent.ResourcesNested<N>>
    implements PersistentVolumeClaimSpecFluent.ResourcesNested<N>,
    Nested<N> {
        private final ResourceRequirementsBuilder builder;

        ResourcesNestedImpl(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.builder = new ResourceRequirementsBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeClaimSpecFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }

    public class DataSourceNestedImpl<N>
    extends TypedLocalObjectReferenceFluentImpl<PersistentVolumeClaimSpecFluent.DataSourceNested<N>>
    implements PersistentVolumeClaimSpecFluent.DataSourceNested<N>,
    Nested<N> {
        private final TypedLocalObjectReferenceBuilder builder;

        DataSourceNestedImpl(TypedLocalObjectReference item) {
            this.builder = new TypedLocalObjectReferenceBuilder(this, item);
        }

        DataSourceNestedImpl() {
            this.builder = new TypedLocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeClaimSpecFluentImpl.this.withDataSource(this.builder.build());
        }

        @Override
        public N endDataSource() {
            return this.and();
        }
    }
}

