/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model.authorization;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.authorization.ResourceRule;
import io.dekorate.deps.kubernetes.api.model.authorization.ResourceRuleFluent;
import io.dekorate.deps.kubernetes.api.model.authorization.ResourceRuleFluentImpl;

public class ResourceRuleBuilder
extends ResourceRuleFluentImpl<ResourceRuleBuilder>
implements VisitableBuilder<ResourceRule, ResourceRuleBuilder> {
    ResourceRuleFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceRuleBuilder() {
        this(true);
    }

    public ResourceRuleBuilder(Boolean validationEnabled) {
        this(new ResourceRule(), validationEnabled);
    }

    public ResourceRuleBuilder(ResourceRuleFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ResourceRuleBuilder(ResourceRuleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ResourceRule(), validationEnabled);
    }

    public ResourceRuleBuilder(ResourceRuleFluent<?> fluent, ResourceRule instance) {
        this(fluent, instance, true);
    }

    public ResourceRuleBuilder(ResourceRuleFluent<?> fluent, ResourceRule instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiGroups(instance.getApiGroups());
        fluent.withResourceNames(instance.getResourceNames());
        fluent.withResources(instance.getResources());
        fluent.withVerbs(instance.getVerbs());
        this.validationEnabled = validationEnabled;
    }

    public ResourceRuleBuilder(ResourceRule instance) {
        this(instance, (Boolean)true);
    }

    public ResourceRuleBuilder(ResourceRule instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiGroups(instance.getApiGroups());
        this.withResourceNames(instance.getResourceNames());
        this.withResources(instance.getResources());
        this.withVerbs(instance.getVerbs());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ResourceRule build() {
        ResourceRule buildable = new ResourceRule(this.fluent.getApiGroups(), this.fluent.getResourceNames(), this.fluent.getResources(), this.fluent.getVerbs());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceRuleBuilder that = (ResourceRuleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

