/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client;

import io.dekorate.deps.kubernetes.api.model.Binding;
import io.dekorate.deps.kubernetes.api.model.ComponentStatus;
import io.dekorate.deps.kubernetes.api.model.ComponentStatusList;
import io.dekorate.deps.kubernetes.api.model.ConfigMap;
import io.dekorate.deps.kubernetes.api.model.ConfigMapList;
import io.dekorate.deps.kubernetes.api.model.Doneable;
import io.dekorate.deps.kubernetes.api.model.DoneableBinding;
import io.dekorate.deps.kubernetes.api.model.DoneableComponentStatus;
import io.dekorate.deps.kubernetes.api.model.DoneableConfigMap;
import io.dekorate.deps.kubernetes.api.model.DoneableEndpoints;
import io.dekorate.deps.kubernetes.api.model.DoneableEvent;
import io.dekorate.deps.kubernetes.api.model.DoneableLimitRange;
import io.dekorate.deps.kubernetes.api.model.DoneableNamespace;
import io.dekorate.deps.kubernetes.api.model.DoneableNode;
import io.dekorate.deps.kubernetes.api.model.DoneablePersistentVolume;
import io.dekorate.deps.kubernetes.api.model.DoneablePersistentVolumeClaim;
import io.dekorate.deps.kubernetes.api.model.DoneablePod;
import io.dekorate.deps.kubernetes.api.model.DoneableReplicationController;
import io.dekorate.deps.kubernetes.api.model.DoneableResourceQuota;
import io.dekorate.deps.kubernetes.api.model.DoneableSecret;
import io.dekorate.deps.kubernetes.api.model.DoneableService;
import io.dekorate.deps.kubernetes.api.model.DoneableServiceAccount;
import io.dekorate.deps.kubernetes.api.model.Endpoints;
import io.dekorate.deps.kubernetes.api.model.EndpointsList;
import io.dekorate.deps.kubernetes.api.model.Event;
import io.dekorate.deps.kubernetes.api.model.EventList;
import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.deps.kubernetes.api.model.KubernetesListBuilder;
import io.dekorate.deps.kubernetes.api.model.KubernetesResourceList;
import io.dekorate.deps.kubernetes.api.model.LimitRange;
import io.dekorate.deps.kubernetes.api.model.LimitRangeList;
import io.dekorate.deps.kubernetes.api.model.Namespace;
import io.dekorate.deps.kubernetes.api.model.NamespaceList;
import io.dekorate.deps.kubernetes.api.model.Node;
import io.dekorate.deps.kubernetes.api.model.NodeList;
import io.dekorate.deps.kubernetes.api.model.PersistentVolume;
import io.dekorate.deps.kubernetes.api.model.PersistentVolumeClaim;
import io.dekorate.deps.kubernetes.api.model.PersistentVolumeClaimList;
import io.dekorate.deps.kubernetes.api.model.PersistentVolumeList;
import io.dekorate.deps.kubernetes.api.model.Pod;
import io.dekorate.deps.kubernetes.api.model.PodList;
import io.dekorate.deps.kubernetes.api.model.ReplicationController;
import io.dekorate.deps.kubernetes.api.model.ReplicationControllerList;
import io.dekorate.deps.kubernetes.api.model.ResourceQuota;
import io.dekorate.deps.kubernetes.api.model.ResourceQuotaList;
import io.dekorate.deps.kubernetes.api.model.Secret;
import io.dekorate.deps.kubernetes.api.model.SecretList;
import io.dekorate.deps.kubernetes.api.model.Service;
import io.dekorate.deps.kubernetes.api.model.ServiceAccount;
import io.dekorate.deps.kubernetes.api.model.ServiceAccountList;
import io.dekorate.deps.kubernetes.api.model.ServiceList;
import io.dekorate.deps.kubernetes.api.model.apiextensions.CustomResourceDefinition;
import io.dekorate.deps.kubernetes.api.model.apiextensions.CustomResourceDefinitionList;
import io.dekorate.deps.kubernetes.api.model.apiextensions.DoneableCustomResourceDefinition;
import io.dekorate.deps.kubernetes.api.model.coordination.v1.DoneableLease;
import io.dekorate.deps.kubernetes.api.model.coordination.v1.Lease;
import io.dekorate.deps.kubernetes.api.model.coordination.v1.LeaseList;
import io.dekorate.deps.kubernetes.client.AppsAPIGroupClient;
import io.dekorate.deps.kubernetes.client.AutoscalingAPIGroupClient;
import io.dekorate.deps.kubernetes.client.BaseClient;
import io.dekorate.deps.kubernetes.client.BatchAPIGroupClient;
import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.ConfigBuilder;
import io.dekorate.deps.kubernetes.client.ExtensionsAPIGroupClient;
import io.dekorate.deps.kubernetes.client.KubernetesClientException;
import io.dekorate.deps.kubernetes.client.MetricAPIGroupClient;
import io.dekorate.deps.kubernetes.client.NamespacedKubernetesClient;
import io.dekorate.deps.kubernetes.client.NetworkAPIGroupClient;
import io.dekorate.deps.kubernetes.client.PolicyAPIGroupClient;
import io.dekorate.deps.kubernetes.client.RbacAPIGroupClient;
import io.dekorate.deps.kubernetes.client.RequestConfig;
import io.dekorate.deps.kubernetes.client.SchedulingAPIGroupClient;
import io.dekorate.deps.kubernetes.client.SettingsAPIGroupClient;
import io.dekorate.deps.kubernetes.client.StorageAPIGroupClient;
import io.dekorate.deps.kubernetes.client.VersionInfo;
import io.dekorate.deps.kubernetes.client.WithRequestCallable;
import io.dekorate.deps.kubernetes.client.dsl.AppsAPIGroupDSL;
import io.dekorate.deps.kubernetes.client.dsl.AutoscalingAPIGroupDSL;
import io.dekorate.deps.kubernetes.client.dsl.BatchAPIGroupDSL;
import io.dekorate.deps.kubernetes.client.dsl.ExtensionsAPIGroupDSL;
import io.dekorate.deps.kubernetes.client.dsl.FunctionCallable;
import io.dekorate.deps.kubernetes.client.dsl.KubernetesListMixedOperation;
import io.dekorate.deps.kubernetes.client.dsl.MetricAPIGroupDSL;
import io.dekorate.deps.kubernetes.client.dsl.MixedOperation;
import io.dekorate.deps.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.dekorate.deps.kubernetes.client.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.dekorate.deps.kubernetes.client.dsl.NetworkAPIGroupDSL;
import io.dekorate.deps.kubernetes.client.dsl.NonNamespaceOperation;
import io.dekorate.deps.kubernetes.client.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.dekorate.deps.kubernetes.client.dsl.PodResource;
import io.dekorate.deps.kubernetes.client.dsl.PolicyAPIGroupDSL;
import io.dekorate.deps.kubernetes.client.dsl.RbacAPIGroupDSL;
import io.dekorate.deps.kubernetes.client.dsl.Resource;
import io.dekorate.deps.kubernetes.client.dsl.RollableScalableResource;
import io.dekorate.deps.kubernetes.client.dsl.SchedulingAPIGroupDSL;
import io.dekorate.deps.kubernetes.client.dsl.ServiceResource;
import io.dekorate.deps.kubernetes.client.dsl.SettingsAPIGroupDSL;
import io.dekorate.deps.kubernetes.client.dsl.StorageAPIGroupDSL;
import io.dekorate.deps.kubernetes.client.dsl.SubjectAccessReviewDSL;
import io.dekorate.deps.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.dekorate.deps.kubernetes.client.dsl.internal.BindingOperationsImpl;
import io.dekorate.deps.kubernetes.client.dsl.internal.ClusterOperationsImpl;
import io.dekorate.deps.kubernetes.client.dsl.internal.ComponentStatusOperationsImpl;
import io.dekorate.deps.kubernetes.client.dsl.internal.ConfigMapOperationsImpl;
import io.dekorate.deps.kubernetes.client.dsl.internal.CustomResourceDefinitionOperationsImpl;
import io.dekorate.deps.kubernetes.client.dsl.internal.CustomResourceOperationContext;
import io.dekorate.deps.kubernetes.client.dsl.internal.CustomResourceOperationsImpl;
import io.dekorate.deps.kubernetes.client.dsl.internal.EndpointsOperationsImpl;
import io.dekorate.deps.kubernetes.client.dsl.internal.EventOperationsImpl;
import io.dekorate.deps.kubernetes.client.dsl.internal.KubernetesListOperationsImpl;
import io.dekorate.deps.kubernetes.client.dsl.internal.LeaseOperationsImpl;
import io.dekorate.deps.kubernetes.client.dsl.internal.LimitRangeOperationsImpl;
import io.dekorate.deps.kubernetes.client.dsl.internal.NamespaceOperationsImpl;
import io.dekorate.deps.kubernetes.client.dsl.internal.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl;
import io.dekorate.deps.kubernetes.client.dsl.internal.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl;
import io.dekorate.deps.kubernetes.client.dsl.internal.NodeOperationsImpl;
import io.dekorate.deps.kubernetes.client.dsl.internal.PersistentVolumeClaimOperationsImpl;
import io.dekorate.deps.kubernetes.client.dsl.internal.PersistentVolumeOperationsImpl;
import io.dekorate.deps.kubernetes.client.dsl.internal.PodOperationsImpl;
import io.dekorate.deps.kubernetes.client.dsl.internal.RawCustomResourceOperationsImpl;
import io.dekorate.deps.kubernetes.client.dsl.internal.ReplicationControllerOperationsImpl;
import io.dekorate.deps.kubernetes.client.dsl.internal.ResourceQuotaOperationsImpl;
import io.dekorate.deps.kubernetes.client.dsl.internal.SecretOperationsImpl;
import io.dekorate.deps.kubernetes.client.dsl.internal.ServiceAccountOperationsImpl;
import io.dekorate.deps.kubernetes.client.dsl.internal.ServiceOperationsImpl;
import io.dekorate.deps.kubernetes.client.dsl.internal.SubjectAccessReviewDSLImpl;
import io.dekorate.deps.kubernetes.client.extended.leaderelection.LeaderElectorBuilder;
import io.dekorate.deps.kubernetes.client.informers.SharedInformerFactory;
import io.dekorate.deps.kubernetes.client.utils.Serialization;
import io.dekorate.deps.okhttp3.OkHttpClient;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;

public class DefaultKubernetesClient
extends BaseClient
implements NamespacedKubernetesClient {
    public DefaultKubernetesClient() throws KubernetesClientException {
    }

    public DefaultKubernetesClient(String masterUrl) throws KubernetesClientException {
        super(masterUrl);
    }

    public DefaultKubernetesClient(Config config) throws KubernetesClientException {
        super(config);
    }

    public DefaultKubernetesClient(OkHttpClient httpClient, Config config) throws KubernetesClientException {
        super(httpClient, config);
    }

    public static DefaultKubernetesClient fromConfig(String config) {
        return new DefaultKubernetesClient(Serialization.unmarshal(config, Config.class));
    }

    public static DefaultKubernetesClient fromConfig(InputStream is) {
        return new DefaultKubernetesClient(Serialization.unmarshal(is, Config.class));
    }

    @Override
    public MixedOperation<ComponentStatus, ComponentStatusList, DoneableComponentStatus, Resource<ComponentStatus, DoneableComponentStatus>> componentstatuses() {
        return new ComponentStatusOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> load(InputStream is) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.httpClient, this.getConfiguration(), this.getNamespace(), null, false, false, new ArrayList(), is, null, true){};
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(KubernetesResourceList item) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.httpClient, this.getConfiguration(), this.getNamespace(), null, false, false, new ArrayList(), item, null, null, -1L, null, true){};
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(HasMetadata ... items) {
        return this.resourceList(((KubernetesListBuilder)new KubernetesListBuilder().withItems(items)).build());
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(Collection<HasMetadata> items) {
        return this.resourceList(((KubernetesListBuilder)new KubernetesListBuilder().withItems(new ArrayList<HasMetadata>(items))).build());
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(String s) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.httpClient, this.getConfiguration(), this.getNamespace(), null, false, false, new ArrayList(), s, null, null, -1L, null, true){};
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(HasMetadata item) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.httpClient, this.getConfiguration(), this.getNamespace(), null, false, false, new ArrayList(), item, -1L, null, true){};
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(String s) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.httpClient, this.getConfiguration(), this.getNamespace(), null, false, false, new ArrayList(), s, -1L, null, true){};
    }

    @Override
    public MixedOperation<Binding, KubernetesResourceList, DoneableBinding, Resource<Binding, DoneableBinding>> bindings() {
        return new BindingOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<Endpoints, EndpointsList, DoneableEndpoints, Resource<Endpoints, DoneableEndpoints>> endpoints() {
        return new EndpointsOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<Event, EventList, DoneableEvent, Resource<Event, DoneableEvent>> events() {
        return new EventOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<Namespace, NamespaceList, DoneableNamespace, Resource<Namespace, DoneableNamespace>> namespaces() {
        return new NamespaceOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<Node, NodeList, DoneableNode, Resource<Node, DoneableNode>> nodes() {
        return new NodeOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<PersistentVolume, PersistentVolumeList, DoneablePersistentVolume, Resource<PersistentVolume, DoneablePersistentVolume>> persistentVolumes() {
        return new PersistentVolumeOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, DoneablePersistentVolumeClaim, Resource<PersistentVolumeClaim, DoneablePersistentVolumeClaim>> persistentVolumeClaims() {
        return new PersistentVolumeClaimOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> pods() {
        return new PodOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<ReplicationController, ReplicationControllerList, DoneableReplicationController, RollableScalableResource<ReplicationController, DoneableReplicationController>> replicationControllers() {
        return new ReplicationControllerOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<ResourceQuota, ResourceQuotaList, DoneableResourceQuota, Resource<ResourceQuota, DoneableResourceQuota>> resourceQuotas() {
        return new ResourceQuotaOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public SchedulingAPIGroupDSL scheduling() {
        return this.adapt(SchedulingAPIGroupClient.class);
    }

    @Override
    public MixedOperation<Secret, SecretList, DoneableSecret, Resource<Secret, DoneableSecret>> secrets() {
        return new SecretOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<Service, ServiceList, DoneableService, ServiceResource<Service, DoneableService>> services() {
        return new ServiceOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<ServiceAccount, ServiceAccountList, DoneableServiceAccount, Resource<ServiceAccount, DoneableServiceAccount>> serviceAccounts() {
        return new ServiceAccountOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public KubernetesListMixedOperation lists() {
        return new KubernetesListOperationsImpl(this.httpClient, this.getConfiguration(), this.getNamespace());
    }

    @Override
    public MixedOperation<ConfigMap, ConfigMapList, DoneableConfigMap, Resource<ConfigMap, DoneableConfigMap>> configMaps() {
        return new ConfigMapOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<LimitRange, LimitRangeList, DoneableLimitRange, Resource<LimitRange, DoneableLimitRange>> limitRanges() {
        return new LimitRangeOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<CustomResourceDefinition, CustomResourceDefinitionList, DoneableCustomResourceDefinition, Resource<CustomResourceDefinition, DoneableCustomResourceDefinition>> customResourceDefinitions() {
        return new CustomResourceDefinitionOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public <T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>> MixedOperation<T, L, D, Resource<T, D>> customResources(CustomResourceDefinition crd, Class<T> resourceType, Class<L> listClass, Class<D> doneClass) {
        return new CustomResourceOperationsImpl(new CustomResourceOperationContext().withOkhttpClient(this.httpClient).withConfig(this.getConfiguration()).withCrd(crd).withType(resourceType).withListType(listClass).withDoneableType(doneClass));
    }

    @Override
    public RawCustomResourceOperationsImpl customResource(CustomResourceDefinitionContext customResourceDefinition) {
        return new RawCustomResourceOperationsImpl(this.httpClient, this.getConfiguration(), customResourceDefinition);
    }

    @Override
    public <T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>> MixedOperation<T, L, D, Resource<T, D>> customResource(CustomResourceDefinition crd, Class<T> resourceType, Class<L> listClass, Class<D> doneClass) {
        return this.customResources(crd, resourceType, listClass, doneClass);
    }

    @Override
    public NamespacedKubernetesClient inNamespace(String namespace) {
        Config updated = ((ConfigBuilder)new ConfigBuilder(this.getConfiguration()).withNamespace(namespace)).build();
        return new DefaultKubernetesClient(this.httpClient, updated);
    }

    @Override
    public NamespacedKubernetesClient inAnyNamespace() {
        return this.inNamespace(null);
    }

    @Override
    public FunctionCallable<NamespacedKubernetesClient> withRequestConfig(RequestConfig requestConfig) {
        return new WithRequestCallable<NamespacedKubernetesClient>(this, requestConfig);
    }

    @Override
    public ExtensionsAPIGroupDSL extensions() {
        return this.adapt(ExtensionsAPIGroupClient.class);
    }

    @Override
    public VersionInfo getVersion() {
        return new ClusterOperationsImpl(this.httpClient, this.getConfiguration(), "version").fetchVersion();
    }

    @Override
    public AppsAPIGroupDSL apps() {
        return this.adapt(AppsAPIGroupClient.class);
    }

    @Override
    public AutoscalingAPIGroupDSL autoscaling() {
        return this.adapt(AutoscalingAPIGroupClient.class);
    }

    @Override
    public NetworkAPIGroupDSL network() {
        return this.adapt(NetworkAPIGroupClient.class);
    }

    @Override
    public StorageAPIGroupDSL storage() {
        return this.adapt(StorageAPIGroupClient.class);
    }

    @Override
    public BatchAPIGroupDSL batch() {
        return this.adapt(BatchAPIGroupClient.class);
    }

    @Override
    public MetricAPIGroupDSL top() {
        return this.adapt(MetricAPIGroupClient.class);
    }

    @Override
    public PolicyAPIGroupDSL policy() {
        return this.adapt(PolicyAPIGroupClient.class);
    }

    @Override
    public RbacAPIGroupDSL rbac() {
        return this.adapt(RbacAPIGroupClient.class);
    }

    @Override
    public SettingsAPIGroupDSL settings() {
        return this.adapt(SettingsAPIGroupClient.class);
    }

    @Override
    public SubjectAccessReviewDSL subjectAccessReviewAuth() {
        return new SubjectAccessReviewDSLImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public SharedInformerFactory informers() {
        return new SharedInformerFactory(ForkJoinPool.commonPool(), this.httpClient, this.getConfiguration());
    }

    @Override
    public SharedInformerFactory informers(ExecutorService executorService) {
        return new SharedInformerFactory(executorService, this.httpClient, this.getConfiguration());
    }

    public LeaderElectorBuilder<NamespacedKubernetesClient> leaderElector() {
        return new LeaderElectorBuilder<NamespacedKubernetesClient>(this);
    }

    @Override
    public MixedOperation<Lease, LeaseList, DoneableLease, Resource<Lease, DoneableLease>> leases() {
        return new LeaseOperationsImpl(this.httpClient, this.getConfiguration());
    }
}

