/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client.handlers;

import io.dekorate.deps.kubernetes.api.model.ConfigMap;
import io.dekorate.deps.kubernetes.api.model.ConfigMapBuilder;
import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.ResourceHandler;
import io.dekorate.deps.kubernetes.client.Watch;
import io.dekorate.deps.kubernetes.client.Watcher;
import io.dekorate.deps.kubernetes.client.dsl.Gettable;
import io.dekorate.deps.kubernetes.client.dsl.Resource;
import io.dekorate.deps.kubernetes.client.dsl.internal.ConfigMapOperationsImpl;
import io.dekorate.deps.okhttp3.OkHttpClient;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class ConfigMapHandler
implements ResourceHandler<ConfigMap, ConfigMapBuilder> {
    @Override
    public String getKind() {
        return ConfigMap.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "v1";
    }

    @Override
    public ConfigMap create(OkHttpClient client, Config config, String namespace, ConfigMap item) {
        return (ConfigMap)new ConfigMapOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new ConfigMap[0]);
    }

    @Override
    public ConfigMap replace(OkHttpClient client, Config config, String namespace, ConfigMap item) {
        return (ConfigMap)((Resource)new ConfigMapOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public ConfigMap reload(OkHttpClient client, Config config, String namespace, ConfigMap item) {
        return (ConfigMap)((Gettable)((Resource)new ConfigMapOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public ConfigMapBuilder edit(ConfigMap item) {
        return new ConfigMapBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, ConfigMap item) {
        return (Boolean)new ConfigMapOperationsImpl(client, config, namespace).withItem(item).cascading(cascading).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ConfigMap item, Watcher<ConfigMap> watcher) {
        return (Watch)((Resource)new ConfigMapOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ConfigMap item, String resourceVersion, Watcher<ConfigMap> watcher) {
        return (Watch)((Resource)new ConfigMapOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public ConfigMap waitUntilReady(OkHttpClient client, Config config, String namespace, ConfigMap item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ConfigMap)((Resource)new ConfigMapOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public ConfigMap waitUntilCondition(OkHttpClient client, Config config, String namespace, ConfigMap item, Predicate<ConfigMap> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ConfigMap)((Resource)new ConfigMapOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

