/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client.utils;

import io.dekorate.deps.kubernetes.client.Callback;
import io.dekorate.deps.kubernetes.client.utils.InputStreamPumper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingInputStreamPumper
extends InputStreamPumper {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputStreamReader.class);
    private Thread thread;

    public BlockingInputStreamPumper(InputStream in, Callback<byte[]> callback) {
        this(in, callback, null);
    }

    public BlockingInputStreamPumper(InputStream in, Callback<byte[]> callback, Runnable onClose) {
        super(in, callback, onClose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BlockingInputStreamPumper blockingInputStreamPumper = this;
        synchronized (blockingInputStreamPumper) {
            this.thread = Thread.currentThread();
        }
        byte[] buffer = new byte[1024];
        try {
            int length;
            while (this.keepReading && !Thread.currentThread().isInterrupted() && (length = this.in.read(buffer)) != -1) {
                byte[] actual = new byte[length];
                System.arraycopy(buffer, 0, actual, 0, length);
                this.callback.call(actual);
            }
        }
        catch (IOException e) {
            if (!this.keepReading) {
                return;
            }
            if (!this.thread.isInterrupted()) {
                LOGGER.error("Error while pumping stream.", (Throwable)e);
            } else {
                LOGGER.debug("Interrupted while pumping stream.");
            }
        }
        finally {
            this.close();
        }
    }
}

