/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.openshift.client;

import io.dekorate.deps.kubernetes.client.Client;
import io.dekorate.deps.kubernetes.client.ExtensionAdapter;
import io.dekorate.deps.okhttp3.OkHttpClient;
import io.dekorate.deps.openshift.client.DefaultOpenShiftClient;
import io.dekorate.deps.openshift.client.NamespacedOpenShiftClient;
import io.dekorate.deps.openshift.client.OpenShiftConfig;
import io.dekorate.deps.openshift.client.OpenShiftNotAvailableException;
import io.dekorate.deps.openshift.client.OpenshiftAdapterSupport;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;

@Component
@Service
public class NamespacedOpenShiftExtensionAdapter
extends OpenshiftAdapterSupport
implements ExtensionAdapter<NamespacedOpenShiftClient> {
    @Override
    public Class<NamespacedOpenShiftClient> getExtensionType() {
        return NamespacedOpenShiftClient.class;
    }

    @Override
    public NamespacedOpenShiftClient adapt(Client client) {
        if (!this.isAdaptable(client).booleanValue()) {
            throw new OpenShiftNotAvailableException("OpenShift is not available. Root paths at: " + client.getMasterUrl() + " do not include /oapi or the new /apis/*.openshift.io APIs.");
        }
        return new DefaultOpenShiftClient(client.adapt(OkHttpClient.class), OpenShiftConfig.wrap(client.getConfiguration()));
    }
}

