/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.docker.buildservice;

import io.dekorate.BuildService;
import io.dekorate.BuildServiceApplicablility;
import io.dekorate.BuildServiceFactory;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.docker.buildservice.DockerBuildService;
import io.dekorate.docker.config.DockerBuildConfig;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.project.Project;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Collection;

public class DockerBuildServiceFactory
implements BuildServiceFactory {
    private static final String DOCKER = "docker";
    private static final String MESSAGE_OK = "Docker build service is applicable.";
    private static final String MESSAGE_NOK = "Docker build service is not applicable to the project, due to not being able find Dockerfile at: %s. Please configure the correct path to the Dockerfile.";

    public BuildService create(Project project, ImageConfiguration config) {
        return new DockerBuildService(project, config);
    }

    public BuildService create(Project project, ImageConfiguration config, Collection<HasMetadata> resources) {
        return new DockerBuildService(project, config);
    }

    public int order() {
        return 10;
    }

    public String name() {
        return DOCKER;
    }

    public BuildServiceApplicablility checkApplicablility(Project project, ImageConfiguration config) {
        if (!(config instanceof DockerBuildConfig)) {
            return new BuildServiceApplicablility(false, "Docker build config not found");
        }
        DockerBuildConfig dockerBuildConfig = (DockerBuildConfig)config;
        String dockerFile = Strings.isNotNullOrEmpty((String)dockerBuildConfig.getDockerFile()) ? dockerBuildConfig.getDockerFile() : "Dockerfile";
        boolean applicable = dockerBuildConfig.isEnabled() && project.getRoot().resolve(dockerFile).toFile().exists();
        String message = applicable ? MESSAGE_OK : String.format(MESSAGE_NOK, project.getRoot().resolve(dockerFile));
        return new BuildServiceApplicablility(applicable, message);
    }

    public BuildServiceApplicablility checkApplicablility(Project project, ConfigurationSupplier<ImageConfiguration> supplier) {
        if (supplier.isExplicit()) {
            return new BuildServiceApplicablility(true, MESSAGE_OK);
        }
        return this.checkApplicablility(project, (ImageConfiguration)supplier.get());
    }
}

