/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.annotation.Protocol;
import java.util.Objects;

public class Port {
    private String name;
    private int containerPort;
    private int hostPort = 0;
    private String path = "/";
    private Protocol protocol = Protocol.TCP;

    public Port() {
    }

    public Port(String name, int containerPort, int hostPort, String path, Protocol protocol) {
        this.name = name;
        this.containerPort = containerPort;
        this.hostPort = hostPort;
        this.path = path != null ? path : "/";
        this.protocol = protocol != null ? protocol : Protocol.TCP;
    }

    public String getName() {
        return this.name;
    }

    public int getContainerPort() {
        return this.containerPort;
    }

    public int getHostPort() {
        return this.hostPort;
    }

    public String getPath() {
        return this.path;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Port that = (Port)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.containerPort != that.containerPort) {
            return false;
        }
        if (this.hostPort != that.hostPort) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        return !(this.protocol != null ? !this.protocol.equals((Object)that.protocol) : that.protocol != null);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.containerPort, this.hostPort, this.path, this.protocol, super.hashCode()});
    }
}

