/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.kubernetes.config.EditableProbe;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ProbeFluent;
import io.dekorate.kubernetes.config.ProbeFluentImpl;
import java.util.Objects;

public class ProbeBuilder
extends ProbeFluentImpl<ProbeBuilder>
implements VisitableBuilder<Probe, ProbeBuilder> {
    ProbeFluent<?> fluent;
    Boolean validationEnabled;

    public ProbeBuilder() {
        this(true);
    }

    public ProbeBuilder(Boolean validationEnabled) {
        this(new Probe(), validationEnabled);
    }

    public ProbeBuilder(ProbeFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ProbeBuilder(ProbeFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Probe(), validationEnabled);
    }

    public ProbeBuilder(ProbeFluent<?> fluent, Probe instance) {
        this(fluent, instance, true);
    }

    public ProbeBuilder(ProbeFluent<?> fluent, Probe instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withHttpActionPath(instance.getHttpActionPath());
        fluent.withExecAction(instance.getExecAction());
        fluent.withTcpSocketAction(instance.getTcpSocketAction());
        fluent.withInitialDelaySeconds(instance.getInitialDelaySeconds());
        fluent.withPeriodSeconds(instance.getPeriodSeconds());
        fluent.withTimeoutSeconds(instance.getTimeoutSeconds());
        fluent.withSuccessThreshold(instance.getSuccessThreshold());
        fluent.withFailureThreshold(instance.getFailureThreshold());
        this.validationEnabled = validationEnabled;
    }

    public ProbeBuilder(Probe instance) {
        this(instance, (Boolean)true);
    }

    public ProbeBuilder(Probe instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withHttpActionPath(instance.getHttpActionPath());
        this.withExecAction(instance.getExecAction());
        this.withTcpSocketAction(instance.getTcpSocketAction());
        this.withInitialDelaySeconds(instance.getInitialDelaySeconds());
        this.withPeriodSeconds(instance.getPeriodSeconds());
        this.withTimeoutSeconds(instance.getTimeoutSeconds());
        this.withSuccessThreshold(instance.getSuccessThreshold());
        this.withFailureThreshold(instance.getFailureThreshold());
        this.validationEnabled = validationEnabled;
    }

    public EditableProbe build() {
        EditableProbe buildable = new EditableProbe(this.fluent.getHttpActionPath(), this.fluent.getExecAction(), this.fluent.getTcpSocketAction(), this.fluent.getInitialDelaySeconds(), this.fluent.getPeriodSeconds(), this.fluent.getTimeoutSeconds(), this.fluent.getSuccessThreshold(), this.fluent.getFailureThreshold());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProbeBuilder that = (ProbeBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

